/*
 * Decompiled with CFR 0.152.
 */
package lib.net.dv8tion.jda.api.interactions.components;

import java.util.ArrayList;
import lib.javax.annotation.CheckReturnValue;
import lib.javax.annotation.Nonnull;
import lib.javax.annotation.Nullable;
import lib.net.dv8tion.jda.api.entities.Message;
import lib.net.dv8tion.jda.api.interactions.components.ActionRow;
import lib.net.dv8tion.jda.api.interactions.components.Button;
import lib.net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import lib.net.dv8tion.jda.api.interactions.components.ComponentLayout;
import lib.net.dv8tion.jda.api.requests.RestAction;

public interface ButtonInteraction
extends ComponentInteraction {
    @Override
    @Nullable
    default public Button getComponent() {
        return this.getButton();
    }

    @Nullable
    public Button getButton();

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> editButton(@Nullable Button newButton) {
        Message message = this.getMessage();
        if (message == null) {
            throw new IllegalStateException("Cannot update button for ephemeral messages! Discord does not provide enough information to perform the update.");
        }
        ArrayList<ActionRow> components = new ArrayList<ActionRow>(message.getActionRows());
        ComponentLayout.updateComponent(components, this.getComponentId(), newButton);
        if (this.isAcknowledged()) {
            return this.getHook().editMessageComponentsById(message.getId(), components).map(it -> null);
        }
        return this.editComponents(components).map(it -> null);
    }
}

