/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.discordintegration.net;

import de.geheimagentnr1.discordintegration.config.ServerConfig;
import de.geheimagentnr1.discordintegration.elements.discord.DiscordEventHandler;
import java.util.Collections;
import java.util.List;
import javax.security.auth.login.LoginException;
import lib.net.dv8tion.jda.api.JDA;
import lib.net.dv8tion.jda.api.JDABuilder;
import lib.net.dv8tion.jda.api.entities.TextChannel;
import lib.net.dv8tion.jda.api.entities.User;
import lib.net.dv8tion.jda.api.requests.GatewayIntent;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiscordNet {
    private static final Logger LOGGER = LogManager.getLogger(DiscordNet.class);
    public static final String FEEDBACK_START = "**```";
    public static final String FEEDBACK_END = "```**";
    private static JDA jda;
    private static TextChannel channel;
    private static final List<GatewayIntent> INTENTS;

    public static synchronized void init() {
        DiscordNet.stop();
        if (ServerConfig.getActive()) {
            try {
                jda = JDABuilder.create(ServerConfig.getBotToken(), INTENTS).addEventListeners(new DiscordEventHandler()).setAutoReconnect(true).build();
                jda.awaitReady();
                channel = jda.getTextChannelById(ServerConfig.getChannelId());
                if (channel == null) {
                    LOGGER.error("Discord Text Channel {} not found", (Object)ServerConfig.getChannelId());
                }
            }
            catch (InterruptedException | LoginException exception) {
                LOGGER.error("Login to Discord failed", (Throwable)exception);
            }
        }
    }

    public static synchronized void stop() {
        if (DiscordNet.isJdaInitialized()) {
            jda.shutdown();
            channel = null;
            jda = null;
        }
    }

    private static synchronized boolean isJdaInitialized() {
        return jda != null;
    }

    public static synchronized boolean isInitialized() {
        return DiscordNet.isJdaInitialized() && channel != null;
    }

    public static synchronized boolean feedBackAllowed(TextChannel _channel, User author) {
        return _channel.getIdLong() == ServerConfig.getChannelId() && _channel.getIdLong() == channel.getIdLong() && author.getIdLong() != jda.getSelfUser().getIdLong();
    }

    public static void sendDeathMessage(LivingDeathEvent event, String customMessage) {
        LivingEntity entity = event.getEntityLiving();
        String name = entity.func_145748_c_().getString();
        if (customMessage.isEmpty()) {
            DiscordNet.sendMessage(event.getSource().func_151519_b(entity).getString().replace(name, "**" + name + "**"));
        } else {
            DiscordNet.sendMessage(String.format("**%s** %s", entity.func_145748_c_().getString(), customMessage));
        }
    }

    public static void sendPlayerMessage(PlayerEntity player, String message) {
        DiscordNet.sendMessage(String.format("**%s** %s", DiscordNet.getPlayerName(player), message));
    }

    public static void sendChatMessage(PlayerEntity player, String message) {
        DiscordNet.sendChatMessage(DiscordNet.getPlayerName(player), message);
    }

    private static String getPlayerName(PlayerEntity player) {
        return player.func_145748_c_().getString();
    }

    public static void sendChatMessage(CommandSource source, ITextComponent message) {
        DiscordNet.sendCommandChatMessage(source, message.getString());
    }

    public static void sendMeChatMessage(CommandSource source, String action) {
        DiscordNet.sendCommandChatMessage(source, String.format("*%s*", action));
    }

    private static void sendCommandChatMessage(CommandSource source, String message) {
        DiscordNet.sendChatMessage(source.func_197019_b().getString(), message);
    }

    private static void sendChatMessage(String name, String message) {
        DiscordNet.sendMessage(String.format("**[%s]** %s", name, message));
    }

    public static void sendFeedbackMessage(String message) {
        for (int start = 0; start <= message.length(); start += 1990) {
            DiscordNet.sendMessage(FEEDBACK_START + message.substring(start, Math.min(message.length(), start + 1990)) + FEEDBACK_END);
        }
    }

    public static synchronized void sendMessage(String message) {
        if (DiscordNet.isInitialized()) {
            try {
                for (int start = 0; start < message.length(); start += 2000) {
                    channel.sendMessage(message.substring(start, Math.min(message.length(), start + 2000))).queue();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Message could not be send", (Throwable)exception);
            }
        }
    }

    static {
        INTENTS = Collections.singletonList(GatewayIntent.GUILD_MESSAGES);
    }
}

