/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.discordintegration.elements.discord;

import de.geheimagentnr1.discordintegration.config.ServerConfig;
import de.geheimagentnr1.discordintegration.elements.discord.DiscordCommandHandler;
import de.geheimagentnr1.discordintegration.net.DiscordNet;
import lib.net.dv8tion.jda.api.entities.User;
import lib.net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;
import lib.net.dv8tion.jda.api.hooks.ListenerAdapter;
import lib.org.jetbrains.annotations.NotNull;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DiscordEventHandler
extends ListenerAdapter {
    private static MinecraftServer server;

    public static void setServer(MinecraftServer _server) {
        server = _server;
    }

    @Override
    public void onGuildMessageReceived(@NotNull GuildMessageReceivedEvent event) {
        User author = event.getAuthor();
        if (this.isInitialized() && DiscordNet.feedBackAllowed(event.getChannel(), author)) {
            String message = event.getMessage().getContentDisplay();
            if (author.isBot()) {
                this.handleBotMessage(message);
            } else if (message.startsWith(ServerConfig.getCommandPrefix())) {
                this.handleCommands(author, message);
            } else if (this.beginnsNotWithOtherCommandPrefix(message)) {
                this.handleUserMessage(message, author);
            }
        }
    }

    private boolean isInitialized() {
        return server != null && DiscordNet.isInitialized();
    }

    private boolean beginnsNotWithOtherCommandPrefix(String message) {
        for (String prefix : ServerConfig.getOtherBotsCommandPrefixes()) {
            if (!message.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    private void handleCommands(User author, String command) {
        if (!author.isBot() && !DiscordCommandHandler.handleCommand(command, server)) {
            DiscordNet.sendFeedbackMessage(String.format("%n%s%nError: Unknown Command", author.getName()));
        }
    }

    private void handleBotMessage(String message) {
        if (!(!ServerConfig.isTransmitBotMessages() || message.startsWith("**```") && message.endsWith("```**"))) {
            server.func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent(message), ChatType.CHAT, Util.field_240973_b_);
        }
    }

    private void handleUserMessage(String message, User author) {
        if (ServerConfig.getMaxCharCount() == -1 || message.length() <= ServerConfig.getMaxCharCount()) {
            server.func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent(String.format("[%s] %s", author.getName(), message)), ChatType.CHAT, Util.field_240973_b_);
        } else {
            DiscordNet.sendFeedbackMessage(String.format("%n%s%nError: Message to long.%nMessages can only be up to %d characters long.%nYour message is %d characters long.", author.getName(), ServerConfig.getMaxCharCount(), message.length()));
        }
    }
}

