/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.discordintegration.elements.commands;

import com.electronwill.nightconfig.core.AbstractCommentedConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.geheimagentnr1.discordintegration.config.CommandConfig;
import de.geheimagentnr1.discordintegration.config.ServerConfig;
import java.util.Comparator;
import java.util.List;
import lib.javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class DiscordCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder discordCommand = Commands.func_197057_a((String)"discord");
        discordCommand.then(Commands.func_197057_a((String)"commands").executes(DiscordCommand::showCommands));
        discordCommand.then(Commands.func_197057_a((String)"gamerules").executes(DiscordCommand::showGamerules));
        discordCommand.then(Commands.func_197057_a((String)"mods").executes(DiscordCommand::showMods));
        dispatcher.register(discordCommand);
    }

    private static int showCommands(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        List<? extends AbstractCommentedConfig> commands = ServerConfig.getCommands();
        commands.sort(Comparator.comparing(CommandConfig::getDiscordCommand));
        for (AbstractCommentedConfig abstractCommentedConfig : commands) {
            if (!CommandConfig.getEnabled(abstractCommentedConfig)) continue;
            source.func_197030_a((ITextComponent)new StringTextComponent(String.format("%s%s - %s", ServerConfig.getCommandPrefix(), CommandConfig.getDiscordCommand(abstractCommentedConfig), CommandConfig.getDescription(abstractCommentedConfig))), false);
        }
        return 1;
    }

    private static int showGamerules(CommandContext<CommandSource> context) {
        final CommandSource source = (CommandSource)context.getSource();
        GameRules.func_223590_a((GameRules.IRuleEntryVisitor)new GameRules.IRuleEntryVisitor(){

            public <T extends GameRules.RuleValue<T>> void func_223481_a(@Nonnull GameRules.RuleKey<T> key, @Nonnull GameRules.RuleType<T> type) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.gamerule.query", new Object[]{key.func_223576_a(), source.func_197028_i().func_200252_aR().func_223585_a(key)}), false);
            }
        });
        return 1;
    }

    private static int showMods(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        ModList.get().forEachModFile(modFile -> {
            for (IModInfo modInfo : modFile.getModInfos()) {
                source.func_197030_a((ITextComponent)new StringTextComponent(String.format("%s (%s) - %s", modInfo.getModId(), modInfo.getVersion(), modFile.getFileName())), false);
            }
        });
        return 1;
    }
}

