/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.discordintegration.config;

import com.electronwill.nightconfig.core.AbstractCommentedConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommandConfig
extends AbstractCommentedConfig {
    private static final ForgeConfigSpec SPEC;
    private static final String DISCORD_COMMAND_NAME = "discord_command";
    private static final String DISCORD_COMMAND_COMMENT = "Dicord command without prefix";
    private static final String MINECRAFT_COMMAND_NAME = "minecraft_command";
    private static final String MINECRAFT_COMMAND_COMMENT = "Minecraft command without prefix ('/')";
    private static final String ENABLED_NAME = "enabled";
    private static final String ENABLED_COMMENT = "Should the command be active?";
    private static final String DESCRIPTION_NAME = "description";
    private static final String DESCRIPTION_COMMENT = "Description for the help command";

    private CommandConfig(UnmodifiableCommentedConfig toCopy, Supplier<Map<String, Object>> mapCreator) {
        super(toCopy, mapCreator);
    }

    CommandConfig(String discordCommand, String minecraftCommand, boolean enabled, String description) {
        super(() -> {
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues.put(DISCORD_COMMAND_NAME, discordCommand);
            defaultValues.put(MINECRAFT_COMMAND_NAME, minecraftCommand);
            defaultValues.put(ENABLED_NAME, enabled);
            defaultValues.put(DESCRIPTION_NAME, description);
            return defaultValues;
        });
        this.setComment(DISCORD_COMMAND_NAME, DISCORD_COMMAND_COMMENT);
        this.setComment(MINECRAFT_COMMAND_NAME, MINECRAFT_COMMAND_COMMENT);
        this.setComment(ENABLED_NAME, ENABLED_COMMENT);
        this.setComment(DESCRIPTION_NAME, DESCRIPTION_COMMENT);
    }

    static boolean isCorrect(Object object) {
        if (object instanceof AbstractCommentedConfig) {
            return SPEC.isCorrect((CommentedConfig)((AbstractCommentedConfig)object));
        }
        return false;
    }

    public final CommandConfig clone() {
        return new CommandConfig((UnmodifiableCommentedConfig)this, this.mapCreator);
    }

    public CommentedConfig createSubConfig() {
        return new CommandConfig(CommandConfig.getDiscordCommand(this), CommandConfig.getMinecraftCommand(this), CommandConfig.getEnabled(this), CommandConfig.getDescription(this));
    }

    public ConfigFormat<?> configFormat() {
        return SPEC.configFormat();
    }

    public static String getDiscordCommand(AbstractCommentedConfig abstractCommentedConfig) {
        return (String)abstractCommentedConfig.get(DISCORD_COMMAND_NAME);
    }

    public static String getMinecraftCommand(AbstractCommentedConfig abstractCommentedConfig) {
        return (String)abstractCommentedConfig.get(MINECRAFT_COMMAND_NAME);
    }

    public static boolean getEnabled(AbstractCommentedConfig abstractCommentedConfig) {
        return (Boolean)abstractCommentedConfig.get(ENABLED_NAME);
    }

    public static String getDescription(AbstractCommentedConfig abstractCommentedConfig) {
        return (String)abstractCommentedConfig.get(DESCRIPTION_NAME);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment(DISCORD_COMMAND_COMMENT).define(DISCORD_COMMAND_NAME, (Object)"");
        builder.comment(MINECRAFT_COMMAND_COMMENT).define(MINECRAFT_COMMAND_NAME, (Object)"");
        builder.comment(ENABLED_COMMENT).define(ENABLED_NAME, true);
        builder.comment(DESCRIPTION_COMMENT).define(DESCRIPTION_NAME, (Object)"");
        SPEC = builder.build();
    }
}

