/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class DyeableItem {
    private DyeableItem() {
    }

    public static IFormattableTextComponent getColorName(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        DyeColor closest = DyeColor.WHITE;
        int closestDist = Integer.MAX_VALUE;
        for (DyeColor dye : DyeColor.values()) {
            int dyeColor = DyeableItem.getColor(dye);
            if (dyeColor == color) {
                closest = dye;
                closestDist = 0;
                break;
            }
            int dr = dyeColor >> 16 & 0xFF;
            int dg = dyeColor >> 8 & 0xFF;
            int db = dyeColor & 0xFF;
            int dist = (dr - r) * (dr - r) + (dg - g) * (dg - g) + (db - b) * (db - b);
            if (dist >= closestDist) continue;
            closest = dye;
            closestDist = dist;
        }
        TranslationTextComponent colorName = new TranslationTextComponent("color.fairylights." + closest.func_176762_d());
        return closestDist == 0 ? colorName : new TranslationTextComponent("format.fairylights.dyed_colored", new Object[]{colorName});
    }

    public static ITextComponent getDisplayName(ItemStack stack, ITextComponent name) {
        return new TranslationTextComponent("format.fairylights.colored", new Object[]{DyeableItem.getColorName(DyeableItem.getColor(stack)), name});
    }

    public static int getColor(DyeColor color) {
        if (color == DyeColor.BLACK) {
            return 0x323232;
        }
        if (color == DyeColor.GRAY) {
            return 0x606060;
        }
        return color.getColorValue();
    }

    public static Optional<DyeColor> getDyeColor(ItemStack stack) {
        int color = DyeableItem.getColor(stack);
        return Arrays.stream(DyeColor.values()).filter(dye -> DyeableItem.getColor(dye) == color).findFirst();
    }

    public static ItemStack setColor(ItemStack stack, DyeColor dye) {
        return DyeableItem.setColor(stack, DyeableItem.getColor(dye));
    }

    public static ItemStack setColor(ItemStack stack, int color) {
        DyeableItem.setColor(stack.func_196082_o(), color);
        return stack;
    }

    public static CompoundNBT setColor(CompoundNBT tag, DyeColor dye) {
        return DyeableItem.setColor(tag, DyeableItem.getColor(dye));
    }

    public static CompoundNBT setColor(CompoundNBT tag, int color) {
        tag.func_74768_a("color", color);
        return tag;
    }

    public static int getColor(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null ? DyeableItem.getColor(tag) : 0xFFFFFF;
    }

    public static int getColor(CompoundNBT tag) {
        return tag.func_150297_b("color", 3) ? tag.func_74762_e("color") : 0xFFFFFF;
    }
}

