/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener;

import java.util.ConcurrentModificationException;
import java.util.Set;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.fastener.Fastener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;

public class CollectFastenersEvent
extends Event {
    private final World world;
    private final AxisAlignedBB region;
    private final Set<Fastener<?>> fasteners;

    public CollectFastenersEvent(World world, AxisAlignedBB region, Set<Fastener<?>> fasteners) {
        this.world = world;
        this.region = region;
        this.fasteners = fasteners;
    }

    public World getWorld() {
        return this.world;
    }

    public AxisAlignedBB getRegion() {
        return this.region;
    }

    public void accept(Chunk chunk) {
        try {
            for (TileEntity entity : chunk.func_177434_r().values()) {
                this.accept((ICapabilityProvider)entity);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void accept(ICapabilityProvider provider) {
        provider.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(this::accept);
    }

    public void accept(Fastener<?> fastener) {
        if (this.region.func_72318_a(fastener.getConnectionPoint())) {
            this.fasteners.add(fastener);
        }
    }
}

