/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.ArrayList;
import java.util.UUID;
import me.paulf.fairylights.server.collision.CollidableList;
import me.paulf.fairylights.server.collision.FeatureCollisionTree;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.feature.HangingFeature;
import me.paulf.fairylights.util.AABBBuilder;
import me.paulf.fairylights.util.Catenary;
import me.paulf.fairylights.util.matrix.MatrixStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class HangingFeatureConnection<F extends HangingFeature>
extends Connection {
    protected static final FeatureType FEATURE = FeatureType.register("feature");
    protected F[] features = this.createFeatures(0);

    public HangingFeatureConnection(ConnectionType<? extends HangingFeatureConnection<F>> type, World world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
    }

    public final F[] getFeatures() {
        return this.features;
    }

    @Override
    protected void onCalculateCatenary(boolean relocated) {
        this.updateFeatures(relocated);
    }

    protected void updateFeatures(boolean relocated) {
        Catenary catenary = this.getCatenary();
        float spacing = this.getFeatureSpacing();
        float totalLength = catenary.getLength();
        if (totalLength > 64.0f) {
            this.onBeforeUpdateFeatures();
            this.features = this.createFeatures(0);
            this.onAfterUpdateFeatures();
            return;
        }
        F[] prev = this.features;
        ArrayList features = new ArrayList();
        this.onBeforeUpdateFeatures();
        catenary.visitPoints(spacing, true, (index, x, y, z, yaw, pitch) -> {
            Object feature;
            if (!relocated && prev != null && index < prev.length && this.canReuse(prev[index], index)) {
                feature = prev[index];
                ((HangingFeature)feature).set(new Vector3d((double)x, (double)y, (double)z), yaw, pitch);
            } else {
                feature = this.createFeature(index, new Vector3d((double)x, (double)y, (double)z), yaw, pitch);
            }
            this.updateFeature(feature);
            features.add(feature);
        });
        this.features = features.toArray(this.createFeatures(features.size()));
        this.onAfterUpdateFeatures();
    }

    protected boolean canReuse(F feature, int index) {
        return true;
    }

    protected abstract F[] createFeatures(int var1);

    protected abstract F createFeature(int var1, Vector3d var2, float var3, float var4);

    protected abstract float getFeatureSpacing();

    protected void onBeforeUpdateFeatures() {
    }

    protected void updateFeature(F feature) {
    }

    protected void onAfterUpdateFeatures() {
    }

    @Override
    public void addCollision(CollidableList.Builder collision, Vector3d origin) {
        super.addCollision(collision, origin);
        if (this.features.length > 0) {
            MatrixStack matrix = new MatrixStack();
            collision.add(FeatureCollisionTree.build((FeatureType)FEATURE, this.features, f -> {
                Vector3d[] verts;
                Vector3d pos = f.getPoint();
                double x = origin.field_72450_a + pos.field_72450_a;
                double y = origin.field_72448_b + pos.field_72448_b;
                double z = origin.field_72449_c + pos.field_72449_c;
                matrix.push();
                if (f.parallelsCord()) {
                    matrix.rotate(-f.getYaw(), 0.0f, 1.0f, 0.0f);
                    matrix.rotate(f.getPitch(), 0.0f, 0.0f, 1.0f);
                }
                matrix.translate(0.0f, -f.getDescent(), 0.0f);
                AABBBuilder bounds = new AABBBuilder();
                AxisAlignedBB bb = f.getBounds().func_186662_g(0.01);
                for (Vector3d vert : verts = new Vector3d[]{new Vector3d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c), new Vector3d(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c), new Vector3d(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c), new Vector3d(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f), new Vector3d(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c), new Vector3d(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c), new Vector3d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f), new Vector3d(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f)}) {
                    bounds.include(matrix.transform(vert));
                }
                matrix.pop();
                return bounds.add(x, y, z).build();
            }));
        }
    }
}

