/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.client.renderer.block.entity.LightRenderer;
import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.block.entity.LightBlockEntity;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3f;

public class LightBlockEntityRenderer
extends TileEntityRenderer<LightBlockEntity> {
    private final LightRenderer lights = new LightRenderer();

    public LightBlockEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(LightBlockEntity entity, float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
        this.render(entity, delta, matrix, source, packedLight, packedOverlay, entity.getLight());
    }

    private <T extends LightBehavior> void render(LightBlockEntity entity, float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay, Light<T> light) {
        LightModel model = this.lights.getModel(light, -1);
        AxisAlignedBB box = model.getBounds();
        BlockState state = entity.func_195044_w();
        AttachFace face = (AttachFace)state.func_177229_b((Property)LightBlock.field_196366_M);
        float rotation = ((Direction)state.func_177229_b((Property)LightBlock.field_185512_D)).func_185119_l();
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotation));
        if (light.getVariant().isOrientable()) {
            if (face == AttachFace.WALL) {
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            } else if (face == AttachFace.FLOOR) {
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-180.0f));
            }
            matrix.func_227861_a_(0.0, 0.5, 0.0);
        } else if (face == AttachFace.CEILING) {
            matrix.func_227861_a_(0.0, 0.25, 0.0);
        } else if (face == AttachFace.WALL) {
            matrix.func_227861_a_(0.0, 0.1875, 0.125);
        } else {
            matrix.func_227861_a_(0.0, -box.field_72338_b - model.getFloorOffset() - 0.5, 0.0);
        }
        this.lights.render(matrix, this.lights.start(source), light, model, delta, packedLight, packedOverlay);
        matrix.func_227865_b_();
    }
}

