/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.packet;

import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateHats
extends AbstractPacket {
    public CompoundNBT nbt;
    public boolean isFullInventory;

    public PacketUpdateHats() {
    }

    public PacketUpdateHats(CompoundNBT tag, boolean isFullInventory) {
        this.nbt = tag;
        this.isFullInventory = isFullInventory;
    }

    public void writeTo(PacketBuffer buf) {
        buf.func_150786_a(this.nbt);
        buf.writeBoolean(this.isFullInventory);
    }

    public void readFrom(PacketBuffer buf) {
        this.nbt = buf.func_150793_b();
        this.isFullInventory = buf.readBoolean();
    }

    public void process(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            if (this.isFullInventory) {
                HatsSavedData.PlayerHatData hatData = new HatsSavedData.PlayerHatData();
                hatData.read(this.nbt);
                Hats.eventHandlerClient.hatsInventory = hatData;
            } else {
                HatsSavedData.HatPart hatPart = new HatsSavedData.HatPart();
                hatPart.read(this.nbt);
                Hats.eventHandlerClient.updateHatInventory(hatPart);
            }
            this.refreshHats();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void refreshHats() {
        if (Minecraft.func_71410_x().field_71462_r instanceof WorkspaceHats) {
            ((WorkspaceHats)Minecraft.func_71410_x().field_71462_r).refreshHats();
        }
    }
}

