/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.hats.client.gui.IHatSetter;
import me.ichun.mods.hats.client.gui.TutorialHandler;
import me.ichun.mods.hats.client.gui.window.WindowHalfGreyout;
import me.ichun.mods.hats.client.gui.window.WindowHatsList;
import me.ichun.mods.hats.client.gui.window.WindowInputReceiver;
import me.ichun.mods.hats.client.gui.window.WindowSidebar;
import me.ichun.mods.hats.client.gui.window.WindowTutorial;
import me.ichun.mods.hats.client.gui.window.element.ElementHatRender;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.packet.PacketHatCustomisation;
import me.ichun.mods.hats.common.packet.PacketHatLauncherCustomisation;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowConfirmation;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowPopup;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WorkspaceHats
extends Workspace
implements IHatSetter {
    public static final DecimalFormat FORMATTER = new DecimalFormat("#,###,###");
    public final boolean fallback;
    @Nonnull
    public final LivingEntity hatEntity;
    public final HatsSavedData.HatPart hatDetails;
    public final ItemStack hatLauncher;
    public int age;
    public WindowInputReceiver windowInput;
    public WindowHatsList windowHatsList;
    public WindowSidebar windowSidebar;
    public ArrayList<HatsSavedData.HatPart> changedHats = new ArrayList();

    public WorkspaceHats(Screen lastScreen, boolean fallback, @Nonnull LivingEntity hatEntity, @Nullable ItemStack hatLauncher) {
        super(lastScreen, (ITextComponent)new TranslationTextComponent("hats.gui.selection.title"), Hats.configClient.guiMinecraftStyle);
        this.windowInput = new WindowInputReceiver(this);
        this.windows.add(this.windowInput);
        this.fallback = fallback || hatEntity != Minecraft.func_71410_x().field_71439_g || hatLauncher != null;
        this.hatEntity = hatEntity;
        this.hatLauncher = hatLauncher;
        this.hatDetails = hatLauncher != null ? HatHandler.getHatPart(hatLauncher).createCopy() : HatHandler.getHatPart(hatEntity).createCopy();
        this.windowHatsList = new WindowHatsList(this);
        this.addWindow(this.windowHatsList);
        this.windowSidebar = new WindowSidebar(this);
        this.addWindow(this.windowSidebar);
    }

    protected void func_231160_c_() {
        int padding = 10;
        this.windowHatsList.constraints().right((IConstrainable)this, Constraint.Property.Type.RIGHT, padding + 22).top((IConstrainable)this, Constraint.Property.Type.TOP, padding).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding);
        this.windowHatsList.setWidth((int)Math.floor((float)this.getWidth() / 2.0f) - (padding + 22));
        this.windowHatsList.constraint.apply();
        this.windowSidebar.constraints().left((IConstrainable)this.windowHatsList, Constraint.Property.Type.RIGHT, 2).top((IConstrainable)this.windowHatsList, Constraint.Property.Type.TOP, 0).bottom((IConstrainable)this.windowHatsList, Constraint.Property.Type.BOTTOM, 0);
        this.windowSidebar.setWidth(20);
        this.windowSidebar.constraint.apply();
        super.func_231160_c_();
    }

    public void func_231152_a_(Minecraft mc, int width, int height) {
        int padding = 10;
        this.windowHatsList.setWidth((int)Math.floor((float)width / 2.0f) - (padding + 22));
        super.func_231152_a_(mc, width, height);
        this.windowSidebar.resize(mc, width, height);
    }

    public void renderWindows(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderHelper.func_227783_c_();
        boolean invisibleEnt = this.hatEntity.func_82150_aj();
        if (invisibleEnt) {
            this.hatEntity.func_82142_c(false);
        }
        if (this.fallback) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.pushMatrix();
            float zoom = this.windowInput.camDist * 40.0f;
            int x = (int)((float)this.windowHatsList.getLeft() / 2.0f - this.windowInput.x * 40.0f);
            int y = (int)((float)(this.getHeight() / 4) * 3.0f + this.windowInput.y * 40.0f + this.hatEntity.func_213302_cg() / 2.0f * 50.0f - zoom);
            if (this.hatLauncher != null) {
                stack.func_227860_a_();
                y = (int)((float)this.getHeight() / 2.0f + this.windowInput.y * 40.0f - zoom);
                stack.func_227861_a_((double)x, (double)y, 0.0);
                float scale = -160.0f;
                stack.func_227861_a_(0.0, 0.0, 200.0);
                stack.func_227862_a_(scale, scale, scale);
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)iChunUtil.eventHandlerClient.ticks + partialTick + this.windowInput.driftYaw * 2.0f) * 0.5f));
                IRenderTypeBuffer.Impl bufferSource = this.field_230706_i_.func_228019_au_().func_228487_b_();
                this.field_230706_i_.func_175599_af().func_229110_a_(this.hatLauncher, ItemCameraTransforms.TransformType.GUI, 0xF000F0, OverlayTexture.field_229196_a_, stack, (IRenderTypeBuffer)bufferSource);
                bufferSource.func_228461_a_();
                stack.func_227865_b_();
            } else {
                RenderSystem.translatef((float)0.0f, (float)0.0f, (float)200.0f);
                InventoryScreen.func_228187_a_((int)x, (int)y, (int)Math.max(80 - (int)(this.hatEntity.func_213311_cf() * 20.0f + zoom), 10), (float)(x - mouseX), (float)((float)this.getHeight() / 2.0f - (float)mouseY), (LivingEntity)this.hatEntity);
            }
            RenderSystem.popMatrix();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.pushMatrix();
        super.renderWindows(stack, mouseX, mouseY, partialTick);
        RenderSystem.popMatrix();
        if (invisibleEnt) {
            this.hatEntity.func_82142_c(true);
        }
    }

    public boolean usePlayerInventory() {
        return HatHandler.useInventory((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public ArrayList<HatsSavedData.HatPart> getHatPartSource() {
        ArrayList<HatsSavedData.HatPart> source = HatHandler.getHatSource((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        HatResourceHandler.combineLists(source, this.changedHats);
        return source;
    }

    public boolean canDockWindows() {
        return false;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double distX, double distY) {
        return this.func_241217_q_() != null && this.func_231041_ay__() && this.func_241217_q_().func_231045_a_(mouseX, mouseY, button, distX, distY);
    }

    public void addWindowWithHalfGreyout(Window<?> window) {
        WindowHalfGreyout greyout = new WindowHalfGreyout(this, window);
        this.addWindow((Window)greyout);
        greyout.init();
        this.addWindow(window);
    }

    public void func_230446_a_(MatrixStack stack) {
        if (this.fallback) {
            this.func_238651_a_(stack, 0);
        } else {
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.defaultBlendFunc();
            RenderSystem.shadeModel((int)7425);
            Tessellator tessellator = Tessellator.func_178181_a();
            Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int z = this.func_230927_p_();
            WorkspaceHats.func_238462_a_((Matrix4f)matrix, (BufferBuilder)builder, (int)(this.windowHatsList.getRight() - (int)((float)this.windowHatsList.getWidth() / 2.0f)), (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)z, (int)-1072689136, (int)-804253680);
            float x1 = this.windowHatsList.getLeft() - 20;
            float x2 = this.windowHatsList.getRight() - (int)((float)this.windowHatsList.getWidth() / 2.0f);
            float y1 = 0.0f;
            float y2 = this.field_230709_l_;
            int colorA = -1072689136;
            int colorB = -804253680;
            float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
            float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
            float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
            float f3 = (float)(colorA & 0xFF) / 255.0f;
            float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
            float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
            float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
            float f7 = (float)(colorB & 0xFF) / 255.0f;
            builder.func_227888_a_(matrix, x2, y1, (float)z).func_227885_a_(f1, f2, f3, f).func_181675_d();
            builder.func_227888_a_(matrix, x1, y1, (float)z).func_227885_a_(f1, f2, f3, 0.0f).func_181675_d();
            builder.func_227888_a_(matrix, x1, y2, (float)z).func_227885_a_(f5, f6, f7, 0.0f).func_181675_d();
            builder.func_227888_a_(matrix, x2, y2, (float)z).func_227885_a_(f5, f6, f7, f4).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void resetBackground() {
        RenderSystem.popMatrix();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTick);
        if (!this.fallback && Hats.configClient.forceRenderToasts && this.field_230706_i_.field_71474_y.field_74319_N) {
            this.field_230706_i_.field_71474_y.field_74319_N = false;
            this.field_230706_i_.func_193033_an().func_238541_a_(new MatrixStack());
            this.field_230706_i_.field_71474_y.field_74319_N = true;
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.age;
        if (this.age == Hats.configClient.guiAnimationTime + 21 && !Hats.configClient.shownTutorial && this.hatLauncher == null) {
            this.openWindowInCenter((Window)new WindowConfirmation(this, this.renderMinecraftStyle() == 0 ? "window.popup.title" : "", I18n.func_135052_a((String)"hats.gui.tutorial.intro", (Object[])new Object[0]), w -> this.startTutorial(), w -> this.cancelTutorial()){

                public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
                    stack.func_227860_a_();
                    stack.func_227861_a_(0.0, 0.0, 375.0);
                    super.func_230430_a_(stack, mouseX, mouseY, partialTick);
                    stack.func_227865_b_();
                }
            }, 0.55, 0.4, true);
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        if (Hats.eventHandlerClient.serverHasMod) {
            if (this.hatLauncher != null) {
                Hats.channel.sendToServer((AbstractPacket)new PacketHatLauncherCustomisation(HatHandler.getHatPart(this.hatLauncher)));
            }
            Hats.channel.sendToServer((AbstractPacket)new PacketHatCustomisation(this.changedHats, true, this.hatLauncher == null ? HatHandler.getHatPart(this.hatEntity) : new HatsSavedData.HatPart()));
            for (HatsSavedData.HatPart hatPart : Hats.eventHandlerClient.hatsInventory.hatParts) {
                for (int i = this.changedHats.size() - 1; i >= 0; --i) {
                    HatsSavedData.HatPart changedHat = this.changedHats.get(i);
                    if (!hatPart.copyPersonalisation(changedHat)) continue;
                    this.changedHats.remove(i);
                }
            }
            for (HatsSavedData.HatPart customisedHat : this.changedHats) {
                HatsSavedData.HatPart copy = customisedHat.createCopy();
                copy.setCountOfAllTo(0);
                Hats.eventHandlerClient.hatsInventory.hatParts.add(copy);
            }
        }
        this.changedHats.clear();
    }

    public void notifyChanged(@Nonnull HatsSavedData.HatPart part) {
        boolean found = false;
        for (int i = this.changedHats.size() - 1; i >= 0; --i) {
            if (!this.changedHats.get((int)i).name.equals(part.name)) continue;
            found = true;
            this.changedHats.remove(i);
            this.changedHats.add(i, part);
            break;
        }
        if (!found) {
            this.changedHats.add(part);
        }
    }

    public void setNewHat(@Nullable HatsSavedData.HatPart newHat, boolean notify) {
        if (newHat == null) {
            if (this.hatLauncher != null) {
                HatHandler.setHatPart(this.hatLauncher, new HatsSavedData.HatPart());
            } else {
                HatHandler.assignSpecificHat(this.hatEntity, null);
            }
            for (Element<?> element : this.windowHatsList.getCurrentView().list.elements) {
                if (!(element instanceof ElementHatRender)) continue;
                ((ElementHatRender)element).toggleState = false;
            }
        } else {
            if (notify) {
                this.notifyChanged(newHat);
            }
            if (this.hatLauncher != null) {
                HatHandler.setHatPart(this.hatLauncher, newHat);
            } else {
                HatHandler.assignSpecificHat(this.hatEntity, newHat);
            }
        }
        this.onNewHatSet(newHat);
    }

    public void popup(double widthRatio, double heightRatio, Consumer<Workspace> callback, String ... text) {
        this.openWindowInCenter((Window)new WindowPopup(this, this.renderMinecraftStyle() == 0 ? "window.popup.title" : "", callback, text){

            public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
                stack.func_227860_a_();
                stack.func_227861_a_(0.0, 0.0, 375.0);
                super.func_230430_a_(stack, mouseX, mouseY, partialTick);
                stack.func_227865_b_();
            }
        }, widthRatio, heightRatio, true);
    }

    public void refreshHats() {
        this.onNewHatSet(this.hatLauncher != null ? HatHandler.getHatPart(this.hatLauncher) : HatHandler.getHatPart(this.hatEntity));
        this.windowHatsList.getCurrentView().updateSearch(this.windowHatsList.getCurrentView().textField.getText());
        this.func_231152_a_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
    }

    public void startTutorial() {
        TutorialHandler.startTutorial(this);
    }

    public void cancelTutorial() {
        Element btn = (Element)this.windowSidebar.getCurrentView().getById("btnResourceManagement");
        if (btn != null) {
            WindowTutorial dragTut = new WindowTutorial(this, WindowTutorial.Direction.RIGHT, btn.getLeft(), btn.getTop() + btn.getHeight() / 2, (int)((float)this.windowHatsList.getLeft() * 0.8f), 150, w7 -> this.finishTutorial(), I18n.func_135052_a((String)"hats.gui.tutorial.skip", (Object[])new Object[0]));
            this.addWindowWithGreyout(dragTut);
            dragTut.init();
        } else {
            this.popup(0.6, 0.4, w1 -> this.finishTutorial(), I18n.func_135052_a((String)"hats.gui.tutorial.skip", (Object[])new Object[0]));
        }
    }

    public void finishTutorial() {
        Hats.configClient.shownTutorial = true;
        Hats.configClient.save();
    }
}

