/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.config;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.sort.HatSorter;
import me.ichun.mods.hats.common.hats.sort.SortHandler;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import net.minecraft.util.Util;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigClient
extends ConfigBase {
    @CategoryDivider(name="clientOnly")
    @Prop(min=0.0, max=1000.0)
    public int maxHatRenders = 200;
    @Prop(min=0.0, max=1.0)
    public double hatChance = 0.1;
    @Prop(min=0.0, max=5.0)
    public int hatUnlockString = 0;
    @Prop(min=0.0, max=2.0)
    public int guiMinecraftStyle = 2;
    @Prop(min=1.0)
    public int guiAnimationTime = 10;
    public boolean shownTutorial = false;
    public boolean newHatToast = true;
    public boolean forceRenderToasts = true;
    public boolean forceGuiFallback = false;
    public boolean disableHatNameRenderInHatSelector = false;
    public boolean invisibleEntityInHatSelector = false;
    @Prop(min=1.0)
    public int hatLauncherRandomHatSpeed = 5;
    public List<String> filterSorterConfig = (List)Util.func_200696_a(new ArrayList(), list -> {
        list.add("filterUndiscovered");
        list.add("sorterFavourite");
        list.add("sorterRarity:inverse");
        list.add("sorterAlphabetical");
    });
    public static final transient Splitter ON_COLON = Splitter.on((String)":").trimResults().omitEmptyStrings();
    public transient ArrayList<HatSorter> filterSorters = new ArrayList();

    public ConfigClient() {
        super(ModLoadingContext.get().getActiveContainer().getModId() + "-client.toml");
    }

    public void onConfigLoaded() {
        this.filterSorters.clear();
        for (String s : this.filterSorterConfig) {
            List split = ON_COLON.splitToList((CharSequence)s);
            if (split.isEmpty() || !SortHandler.SORTERS.containsKey(split.get(0))) continue;
            try {
                HatSorter sorter = SortHandler.SORTERS.get(split.get(0)).newInstance();
                if (split.size() >= 2) {
                    sorter.isInverse = ((String)split.get(1)).equals("inverse");
                }
                this.filterSorters.add(sorter);
            }
            catch (IllegalAccessException | InstantiationException e) {
                Hats.LOGGER.error("Error creating known sorter type: {}", split.get(0));
                e.printStackTrace();
            }
        }
    }

    @Nonnull
    public String getModId() {
        return "hats";
    }

    @Nonnull
    public String getConfigName() {
        return "Hats";
    }

    @Nonnull
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }
}

