/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.registrator;

import co.eltrut.differentiate.common.interf.IColoredBlock;
import co.eltrut.differentiate.common.interf.IColoredItem;
import co.eltrut.differentiate.common.interf.ICompostableItem;
import co.eltrut.differentiate.common.interf.IFlammableBlock;
import co.eltrut.differentiate.common.interf.IRenderTypeBlock;
import co.eltrut.differentiate.common.interf.IRendererTileEntity;
import co.eltrut.differentiate.common.interf.Interface;
import co.eltrut.differentiate.core.registrator.BlockHelper;
import co.eltrut.differentiate.core.registrator.IHelper;
import co.eltrut.differentiate.core.registrator.ItemHelper;
import co.eltrut.differentiate.core.registrator.TileEntityHelper;
import co.eltrut.differentiate.core.util.DataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Registrator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<Registrator> REGISTRATORS = new ArrayList<Registrator>();
    private final String modid;
    private final Map<IForgeRegistry<?>, IHelper<?>> helpers = new HashMap();

    public Registrator(String modid) {
        this.modid = modid;
        REGISTRATORS.add(this);
        this.helpers.put(ForgeRegistries.ITEMS, new ItemHelper(this));
        this.helpers.put(ForgeRegistries.BLOCKS, new BlockHelper(this));
        this.helpers.put(ForgeRegistries.TILE_ENTITIES, new TileEntityHelper(this));
    }

    public static Registrator create(String modid, Consumer<Registrator> consumer) {
        Registrator registrator = new Registrator(modid);
        consumer.accept(registrator);
        return registrator;
    }

    public void register(IEventBus bus) {
        for (IHelper<?> helper : this.helpers.values()) {
            helper.register(bus);
        }
    }

    public static void registerCommon(FMLCommonSetupEvent event) {
        Registrator.registerAttribute(ForgeRegistries.BLOCKS, ICompostableItem.class, Registrator::registerCompostable);
        Registrator.registerAttribute(ForgeRegistries.ITEMS, ICompostableItem.class, Registrator::registerCompostable);
        LOGGER.info("Registered block and item compostables");
        Registrator.registerAttribute(ForgeRegistries.BLOCKS, IFlammableBlock.class, Registrator::registerFlammable);
        LOGGER.info("Registered block flammables");
    }

    public static void registerClient(FMLClientSetupEvent event) {
        Registrator.registerAttribute(ForgeRegistries.BLOCKS, IRenderTypeBlock.class, Registrator::registerCutout);
        LOGGER.info("Registered block cutouts");
        Registrator.registerAttribute(ForgeRegistries.BLOCKS, IColoredBlock.class, Registrator::registerBlockColor);
        Registrator.registerAttribute(ForgeRegistries.ITEMS, IColoredItem.class, Registrator::registerItemColor);
        LOGGER.info("Registered block and item colors");
        Registrator.registerAttribute(ForgeRegistries.TILE_ENTITIES, IRendererTileEntity.class, Registrator::registerTileEntityRenderer);
        LOGGER.info("Registered tile entity renderers");
    }

    public String getModId() {
        return this.modid;
    }

    public <T extends IHelper<?>> T getHelper(IForgeRegistry<?> registry) {
        return (T)this.helpers.get(registry);
    }

    public Map<IForgeRegistry<?>, IHelper<?>> getHelpers() {
        return this.helpers;
    }

    public static <T extends IForgeRegistryEntry<T>> void registerAttribute(IForgeRegistry<T> registry, Class<? extends Interface> clazz, Consumer<T> consumer) {
        registry.getValues().stream().filter(clazz::isInstance).forEach(consumer);
    }

    private static void registerCompostable(IItemProvider item) {
        ICompostableItem compostableItem = (ICompostableItem)item;
        DataUtil.registerCompostable(item, compostableItem.getCompostableChance());
    }

    private static void registerFlammable(Block block) {
        IFlammableBlock flammableBlock = (IFlammableBlock)block;
        DataUtil.registerFlammable(block, flammableBlock.getEncouragement(), flammableBlock.getFlammability());
    }

    private static void registerCutout(Block block) {
        IRenderTypeBlock renderTypeBlock = (IRenderTypeBlock)block;
        DataUtil.registerCutout(block, renderTypeBlock.getRenderType());
    }

    private static void registerBlockColor(Block block) {
        IColoredBlock coloredBlock = (IColoredBlock)block;
        DataUtil.registerBlockColor(coloredBlock.getBlockColor(), block);
        DataUtil.registerItemColor(coloredBlock.getItemColor(), new IItemProvider[]{block});
    }

    private static void registerItemColor(IItemProvider item) {
        IColoredItem coloredItem = (IColoredItem)item;
        DataUtil.registerItemColor(coloredItem.getItemColor(), item);
    }

    private static <T extends TileEntity> void registerTileEntityRenderer(TileEntityType<T> tileentity) {
        IRendererTileEntity rendererTileEntity = (IRendererTileEntity)tileentity;
        DataUtil.registerTileEntityRenderer(tileentity, rendererTileEntity.getRendererFactory().get());
    }
}

