/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.datagen.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DifferShapelessRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private String group;
    private String[] mods;
    private String[] conditions;
    private String[] flags;

    public DifferShapelessRecipeBuilder(IItemProvider resultIn, int countIn) {
        this.result = resultIn.func_199767_j();
        this.count = countIn;
    }

    public DifferShapelessRecipeBuilder addIngredient(ITag<Item> tagIn) {
        return this.addIngredient(Ingredient.func_199805_a(tagIn));
    }

    public DifferShapelessRecipeBuilder addIngredient(IItemProvider itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public DifferShapelessRecipeBuilder addIngredient(IItemProvider itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
        }
        return this;
    }

    public DifferShapelessRecipeBuilder addIngredient(Ingredient ingredientIn) {
        return this.addIngredient(ingredientIn, 1);
    }

    public DifferShapelessRecipeBuilder addIngredient(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public DifferShapelessRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public DifferShapelessRecipeBuilder addModCompat(String ... mods) {
        this.mods = mods;
        return this;
    }

    public DifferShapelessRecipeBuilder addConditions(String ... conditions) {
        this.conditions = conditions;
        return this;
    }

    public DifferShapelessRecipeBuilder addFlags(String ... flags) {
        this.flags = flags;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        ResourceLocation loc = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        this.build(consumerIn, new ResourceLocation(loc.func_110624_b(), "crafting/" + loc.func_110623_a()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shapeless Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        consumerIn.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.mods == null ? new String[]{} : this.mods, this.conditions == null ? new String[]{} : this.conditions, this.flags == null ? new String[]{} : this.flags));
    }

    private void validate(ResourceLocation id) {
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final String[] mods;
        private final String[] conditions;
        private final String[] flags;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<Ingredient> ingredientsIn, String[] mods, String[] conditions, String[] flags) {
            this.id = idIn;
            this.result = resultIn;
            this.count = countIn;
            this.group = groupIn;
            this.ingredients = ingredientsIn;
            this.mods = mods;
            this.conditions = conditions;
            this.flags = flags;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonobject);
            if (this.conditions.length != 0 || this.mods.length != 0 || this.flags.length != 0) {
                JsonObject temp;
                JsonArray jsonarray1 = new JsonArray();
                for (String mod : this.mods) {
                    if (mod == null) continue;
                    temp = new JsonObject();
                    temp.addProperty("type", "forge:mod_loaded");
                    temp.addProperty("modid", mod);
                    jsonarray1.add((JsonElement)temp);
                }
                for (String condition : this.conditions) {
                    if (condition == null) continue;
                    temp = new JsonObject();
                    temp.addProperty("type", "differentiate:condition");
                    temp.addProperty("condition", condition);
                    jsonarray1.add((JsonElement)temp);
                }
                for (String flag : this.flags) {
                    if (flag == null) continue;
                    temp = new JsonObject();
                    temp.addProperty("type", "differentiate:flag");
                    temp.addProperty("flag", flag);
                    jsonarray1.add((JsonElement)temp);
                }
                json.add("conditions", (JsonElement)jsonarray1);
            }
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222158_b;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

