/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.client.provider;

import java.awt.Color;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MyaliteColorProvider {
    public static final float myaliteS = 0.7f;
    public static final float myaliteB = 0.8f;
    public static final PerlinNoiseGenerator NOISE = new PerlinNoiseGenerator(new SharedSeedRandom(4543543L), IntStream.rangeClosed(-4, 4));

    @OnlyIn(value=Dist.CLIENT)
    public static IBlockColor getBlockColor() {
        return (state, world, pos, tintIndex) -> MyaliteColorProvider.getColor(pos, 0.7f, 0.8f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IItemColor getItemColor() {
        return (stack, tintIndex) -> {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g == null) {
                return MyaliteColorProvider.getColor(BlockPos.field_177992_a, 0.7f, 0.8f);
            }
            BlockPos pos = mc.field_71439_g.func_233580_cy_();
            RayTraceResult res = mc.field_71476_x;
            if (res != null && res instanceof BlockRayTraceResult) {
                pos = ((BlockRayTraceResult)res).func_216350_a();
            }
            return MyaliteColorProvider.getColor(pos, 0.7f, 0.8f);
        };
    }

    public static int getColor(BlockPos pos, float s, float b) {
        double sp = 0.15;
        double range = 0.3;
        double shift = 0.05;
        double x = (double)pos.func_177958_n() * 0.15;
        double y = (double)pos.func_177956_o() * 0.15;
        double z = (double)pos.func_177952_p() * 0.15;
        double xv = x + Math.sin(z) * 2.0;
        double zv = z + Math.cos(x) * 2.0;
        double yv = y + Math.sin(y + 0.7853981633974483) * 2.0;
        double noise = NOISE.func_215464_a(xv + yv, zv + yv * 2.0, false);
        double h = noise * 0.15 - 0.3 + 0.05;
        return Color.HSBtoRGB((float)h, s, b);
    }
}

