/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;

public class WireNodeRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private static final float HANG = 0.5f;

    public WireNodeRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void func_225616_a_(T tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combindOverlayIn) {
        IWireNode te = (IWireNode)tileEntityIn;
        for (int i = 0; i < te.getNodeCount(); ++i) {
            if (te.getNodeType(i) == null) continue;
            Vector3f d1 = te.getNodeOffset(i);
            float ox1 = d1.func_195899_a();
            float oy1 = d1.func_195900_b();
            float oz1 = d1.func_195902_c();
            IWireNode wn = te.getNode(i);
            if (wn == null) {
                return;
            }
            Vector3f d2 = wn.getNodeOffset(te.getOtherNodeIndex(i));
            float ox2 = d2.func_195899_a();
            float oy2 = d2.func_195900_b();
            float oz2 = d2.func_195902_c();
            BlockPos other = te.getNodePos(i);
            float tx = other.func_177958_n() - te.getMyPos().func_177958_n();
            float ty = other.func_177956_o() - te.getMyPos().func_177956_o();
            float tz = other.func_177952_p() - te.getMyPos().func_177952_p();
            matrixStackIn.func_227860_a_();
            float dis = WireNodeRenderer.distanceFromZero(tx, ty, tz);
            matrixStackIn.func_227861_a_((double)(tx + 0.5f + ox2), (double)(ty + 0.5f + oy2), (double)(tz + 0.5f + oz2));
            WireNodeRenderer.wireRender(tileEntityIn, other, matrixStackIn, bufferIn, -tx - ox2 + ox1, -ty - oy2 + oy1, -tz - oz2 + oz1, te.getNodeType(i), dis);
            matrixStackIn.func_227865_b_();
        }
    }

    private static float divf(int a, int b) {
        return (float)a / (float)b;
    }

    private static float hang(float f, float dis) {
        return (float)Math.sin(-f * (float)Math.PI) * (0.5f * dis / (float)IWireNode.MAX_LENGTH);
    }

    public static float distanceFromZero(float x, float y, float z) {
        return (float)Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
    }

    public static void wireRender(TileEntity tileEntityIn, BlockPos other, MatrixStack matrix, IRenderTypeBuffer buffer, float x, float y, float z, WireType type, float dis) {
        IVertexBuilder ivertexbuilder = buffer.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        float f = MathHelper.func_226165_i_((float)(x * x + z * z)) * 0.025f / 2.0f;
        float o1 = z * f;
        float o2 = x * f;
        BlockPos blockpos1 = tileEntityIn.func_174877_v();
        BlockPos blockpos2 = other;
        int i = tileEntityIn.func_145831_w().func_226658_a_(LightType.BLOCK, blockpos1);
        int j = tileEntityIn.func_145831_w().func_226658_a_(LightType.BLOCK, blockpos2);
        int k = tileEntityIn.func_145831_w().func_226658_a_(LightType.SKY, blockpos1);
        int l = tileEntityIn.func_145831_w().func_226658_a_(LightType.SKY, blockpos2);
        WireNodeRenderer.wirePart(ivertexbuilder, matrix4f, x, y, z, j, i, l, k, 0.025f, 0.025f, o1, o2, type, dis);
        WireNodeRenderer.wirePart(ivertexbuilder, matrix4f, x, y, z, j, i, l, k, 0.025f, 0.0f, o1, o2, type, dis);
    }

    public static void wirePart(IVertexBuilder vertBuilder, Matrix4f matrix, float x, float y, float z, int l1, int l2, int l3, int l4, float a, float b, float o1, float o2, WireType type, float dis) {
        for (int j = 0; j < 24; ++j) {
            float f = (float)j / 23.0f;
            int k = (int)MathHelper.func_219799_g((float)f, (float)l1, (float)l2);
            int l = (int)MathHelper.func_219799_g((float)f, (float)l3, (float)l4);
            int light = LightTexture.func_228451_a_((int)k, (int)l);
            WireNodeRenderer.wireVert(vertBuilder, matrix, light, x, y, z, a, b, 24, j, false, o1, o2, type, dis);
            WireNodeRenderer.wireVert(vertBuilder, matrix, light, x, y, z, a, b, 24, j + 1, true, o1, o2, type, dis);
        }
    }

    public static void wireVert(IVertexBuilder vertBuilder, Matrix4f matrix, int light, float x, float y, float z, float a, float b, int count, int index, boolean sw, float o1, float o2, WireType type, float dis) {
        int cr = type.getRed();
        int cg = type.getGreen();
        int cb = type.getBlue();
        if (index % 2 == 0) {
            cr = (int)((float)cr * 0.7f);
            cg = (int)((float)cg * 0.7f);
            cb = (int)((float)cb * 0.7f);
        }
        float part = (float)index / (float)count;
        float fx = x * part;
        float fy = (y > 0.0f ? y * part * part : y - y * (1.0f - part) * (1.0f - part)) + WireNodeRenderer.hang(WireNodeRenderer.divf(index, count), dis);
        float fz = z * part;
        if (Math.abs(x) + Math.abs(z) < Math.abs(y)) {
            boolean p = b > 0.0f;
            float c = 0.015f;
            if (!sw) {
                vertBuilder.func_227888_a_(matrix, fx - c, fy, fz + (p ? -c : c)).func_225586_a_(cr, cg, cb, 255).func_227886_a_(light).func_181675_d();
            }
            vertBuilder.func_227888_a_(matrix, fx + c, fy, fz + (p ? c : -c)).func_225586_a_(cr, cg, cb, 255).func_227886_a_(light).func_181675_d();
            if (sw) {
                vertBuilder.func_227888_a_(matrix, fx - c, fy, fz + (p ? -c : c)).func_225586_a_(cr, cg, cb, 255).func_227886_a_(light).func_181675_d();
            }
        } else {
            if (!sw) {
                vertBuilder.func_227888_a_(matrix, fx + o1, fy + a - b, fz - o2).func_225586_a_(cr, cg, cb, 255).func_227886_a_(light).func_181675_d();
            }
            vertBuilder.func_227888_a_(matrix, fx - o1, fy + b, fz + o2).func_225586_a_(cr, cg, cb, 255).func_227886_a_(light).func_181675_d();
            if (sw) {
                vertBuilder.func_227888_a_(matrix, fx + o1, fy + a - b, fz - o2).func_225586_a_(cr, cg, cb, 255).func_227886_a_(light).func_181675_d();
            }
        }
    }
}

