/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.item;

import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireConnectResult;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.index.CAItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WireSpool
extends Item {
    public WireSpool(Item.Properties props) {
        super(props);
    }

    public ActionResultType func_195939_a(ItemUseContext c) {
        TileEntity te;
        CompoundNBT nbt = c.func_195996_i().func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        if ((te = c.func_195991_k().func_175625_s(c.func_195995_a())) == null) {
            return ActionResultType.PASS;
        }
        if (!(te instanceof IWireNode)) {
            return ActionResultType.PASS;
        }
        IWireNode node = (IWireNode)te;
        if (WireSpool.hasPos(nbt)) {
            WireType connectionType = IWireNode.getTypeOfConnection(c.func_195991_k(), c.func_195995_a(), WireSpool.getPos(nbt));
            WireConnectResult result = WireSpool.isRemover(c.func_195996_i().func_77973_b()) ? IWireNode.disconnect(c.func_195991_k(), c.func_195995_a(), WireSpool.getPos(nbt)) : IWireNode.connect(c.func_195991_k(), WireSpool.getPos(nbt), WireSpool.getNode(nbt), c.func_195995_a(), node.getNodeFromPos(c.func_221532_j()), WireSpool.getWireType(c.func_195996_i().func_77973_b()));
            te.func_70296_d();
            if (!c.func_195999_j().func_184812_l_()) {
                if (result == WireConnectResult.REMOVED) {
                    boolean shouldDrop;
                    c.func_195996_i().func_190918_g(1);
                    ItemStack stack = connectionType.getSourceDrop();
                    boolean bl = shouldDrop = !c.func_195999_j().func_191521_c(stack);
                    if (shouldDrop) {
                        c.func_195999_j().func_71019_a(stack, false);
                    }
                } else if (result.isLinked()) {
                    boolean shouldDrop;
                    c.func_195996_i().func_190918_g(1);
                    ItemStack stack = new ItemStack((IItemProvider)CAItems.SPOOL.get(), 1);
                    boolean bl = shouldDrop = !c.func_195999_j().func_191521_c(stack);
                    if (shouldDrop) {
                        c.func_195999_j().func_71019_a(stack, false);
                    }
                }
            }
            c.func_195996_i().func_77982_d(null);
            c.func_195999_j().func_146105_b(result.getMessage(), true);
        } else {
            int index = node.getNodeFromPos(c.func_221532_j());
            if (index < 0) {
                return ActionResultType.PASS;
            }
            if (!WireSpool.isRemover(c.func_195996_i().func_77973_b())) {
                c.func_195999_j().func_146105_b(WireConnectResult.getConnect(node.isNodeInput(index), node.isNodeOutput(index)).getMessage(), true);
            }
            c.func_195996_i().func_77982_d(null);
            c.func_195996_i().func_77982_d(WireSpool.setContent(nbt, node.getMyPos(), index));
        }
        return ActionResultType.CONSUME;
    }

    public static boolean hasPos(CompoundNBT nbt) {
        if (nbt == null) {
            return false;
        }
        return nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z") && nbt.func_74764_b("node");
    }

    public static BlockPos getPos(CompoundNBT nbt) {
        if (nbt == null) {
            return null;
        }
        return new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
    }

    public static int getNode(CompoundNBT nbt) {
        if (nbt == null) {
            return -1;
        }
        return nbt.func_74762_e("node");
    }

    public static CompoundNBT setContent(CompoundNBT nbt, BlockPos pos, int node) {
        if (nbt == null) {
            return new CompoundNBT();
        }
        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74768_a("y", pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
        nbt.func_74768_a("node", node);
        return nbt;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_77978_p();
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (WireSpool.hasPos(nbt)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.createaddition.spool.nbt"));
        }
    }

    public static WireType getWireType(Item item) {
        if (item == CAItems.COPPER_SPOOL.get()) {
            return WireType.COPPER;
        }
        if (item == CAItems.GOLD_SPOOL.get()) {
            return WireType.GOLD;
        }
        return WireType.COPPER;
    }

    public static boolean isRemover(Item item) {
        return item == CAItems.SPOOL.get();
    }
}

