/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.item;

import com.mrh0.createaddition.config.Config;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;

public class ChargingChromaticCompound
extends Item {
    public static int MAX_CHARGE = (Integer)Config.OVERCHARGING_ENERGY_COST.get();

    public ChargingChromaticCompound(Item.Properties props) {
        super(props);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ChargingChromaticCompound.getCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public static boolean hasKey(CompoundNBT nbt) {
        if (nbt == null) {
            return false;
        }
        return nbt.func_74764_b("charge");
    }

    public static int getEnergy(CompoundNBT nbt) {
        if (nbt == null) {
            return 0;
        }
        if (!ChargingChromaticCompound.hasKey(nbt)) {
            return 0;
        }
        return nbt.func_74762_e("charge");
    }

    public static double getCharge(ItemStack stack) {
        return (double)ChargingChromaticCompound.getEnergy(stack) / (double)MAX_CHARGE;
    }

    public static int getEnergy(ItemStack it) {
        return ChargingChromaticCompound.getEnergy(it.func_77978_p());
    }

    public static int charge(ItemStack stack, int in) {
        CompoundNBT nbt = new CompoundNBT();
        int c = ChargingChromaticCompound.getEnergy(stack.func_77978_p());
        int n = Math.min(c + in, MAX_CHARGE);
        nbt.func_74768_a("charge", n);
        stack.func_77982_d(null);
        stack.func_77982_d(nbt);
        return n - c;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (group != ItemGroup.field_78027_g) {
            return;
        }
        super.func_150895_a(group, list);
    }
}

