/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.rolling_mill;

import com.mrh0.createaddition.blocks.rolling_mill.RollingMillTileEntity;
import com.mrh0.createaddition.index.CATileEntities;
import com.mrh0.createaddition.shapes.CAShapes;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RollingMillBlock
extends HorizontalKineticBlock
implements ITE<RollingMillTileEntity> {
    public static final VoxelShape ROLLING_MILL_SHAPE = CAShapes.shape(0.0, 0.0, 0.0, 16.0, 5.0, 16.0).add(2.0, 0.0, 2.0, 14.0, 16.0, 14.0).build();

    public RollingMillBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return CATileEntities.ROLLING_MILL.create();
    }

    public Class<RollingMillTileEntity> getTileEntityClass() {
        return RollingMillTileEntity.class;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ROLLING_MILL_SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_184586_b(handIn).func_190926_b()) {
            return ActionResultType.PASS;
        }
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, rollingMill -> {
            int slot;
            boolean emptyOutput = true;
            ItemStackHandler inv = rollingMill.outputInv;
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (!stackInSlot.func_190926_b()) {
                    emptyOutput = false;
                }
                player.field_71071_by.func_191975_a(worldIn, stackInSlot);
                inv.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            if (emptyOutput) {
                inv = rollingMill.inputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    player.field_71071_by.func_191975_a(worldIn, inv.getStackInSlot(slot));
                    inv.setStackInSlot(slot, ItemStack.field_190927_a);
                }
            }
            rollingMill.func_70296_d();
            rollingMill.sendData();
        });
        return ActionResultType.SUCCESS;
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        if (entityIn.field_70170_p.field_72995_K) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.func_70089_S()) {
            return;
        }
        RollingMillTileEntity rollingMill = null;
        for (BlockPos pos : Iterate.hereAndBelow((BlockPos)entityIn.func_233580_cy_())) {
            rollingMill = (RollingMillTileEntity)this.getTileEntity(worldIn, pos);
        }
        if (rollingMill == null) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        LazyOptional capability = rollingMill.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (!capability.isPresent()) {
            return;
        }
        ItemStack remainder = ((IItemHandler)capability.orElse((Object)new ItemStackHandler())).insertItem(0, itemEntity.func_92059_d(), false);
        if (remainder.func_190926_b()) {
            itemEntity.func_70106_y();
        }
        if (remainder.func_190916_E() < itemEntity.func_92059_d().func_190916_E()) {
            itemEntity.func_92058_a(remainder);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
                ItemHelper.dropContents((World)worldIn, (BlockPos)pos, (IItemHandler)te.inputInv);
                ItemHelper.dropContents((World)worldIn, (BlockPos)pos, (IItemHandler)te.outputInv);
            });
            worldIn.func_175713_t(pos);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction prefferedSide = this.getPreferredHorizontalFacing(context);
        if (prefferedSide != null) {
            return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_FACING, (Comparable)prefferedSide);
        }
        return super.func_196258_a(context);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k();
    }

    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face.func_176740_k() == ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k();
    }
}

