/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.creative_energy;

import com.mrh0.createaddition.energy.CreativeEnergyStorage;
import com.simibubi.create.content.logistics.block.inventories.CrateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CreativeEnergyTileEntity
extends CrateTileEntity {
    protected final CreativeEnergyStorage energy;
    private LazyOptional<IEnergyStorage> lazyEnergy;
    private boolean firstTickState = true;
    private LazyOptional<IEnergyStorage> escacheUp = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheDown = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheNorth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheEast = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheSouth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheWest = LazyOptional.empty();

    public CreativeEnergyTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.energy = new CreativeEnergyStorage();
        this.lazyEnergy = LazyOptional.of(() -> this.energy);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.lazyEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        for (Direction d : Direction.values()) {
            IEnergyStorage ies = this.getCachedEnergy(d);
            if (ies == null) continue;
            int n = ies.receiveEnergy(Integer.MAX_VALUE, false);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.lazyEnergy.invalidate();
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        for (Direction side : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (te == null) {
                this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
                continue;
            }
            LazyOptional le = te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
            this.setCache(side, (LazyOptional<IEnergyStorage>)le);
        }
    }

    public void setCache(Direction side, LazyOptional<IEnergyStorage> storage) {
        switch (side) {
            case DOWN: {
                this.escacheDown = storage;
                break;
            }
            case EAST: {
                this.escacheEast = storage;
                break;
            }
            case NORTH: {
                this.escacheNorth = storage;
                break;
            }
            case SOUTH: {
                this.escacheSouth = storage;
                break;
            }
            case UP: {
                this.escacheUp = storage;
                break;
            }
            case WEST: {
                this.escacheWest = storage;
            }
        }
    }

    public IEnergyStorage getCachedEnergy(Direction side) {
        switch (side) {
            case DOWN: {
                return (IEnergyStorage)this.escacheDown.orElse(null);
            }
            case EAST: {
                return (IEnergyStorage)this.escacheEast.orElse(null);
            }
            case NORTH: {
                return (IEnergyStorage)this.escacheNorth.orElse(null);
            }
            case SOUTH: {
                return (IEnergyStorage)this.escacheSouth.orElse(null);
            }
            case UP: {
                return (IEnergyStorage)this.escacheUp.orElse(null);
            }
            case WEST: {
                return (IEnergyStorage)this.escacheWest.orElse(null);
            }
        }
        return null;
    }
}

