/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import com.mrh0.createaddition.blocks.connector.ConnectorBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.item.Multimeter;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.IEnergyStorage;

public class ConnectorTileEntity
extends BaseElectricTileEntity
implements IWireNode,
IObserveTileEntity,
IHaveGoggleInformation {
    private BlockPos[] connectionPos = new BlockPos[this.getNodeCount()];
    private int[] connectionIndecies = new int[this.getNodeCount()];
    private WireType[] connectionTypes = new WireType[this.getNodeCount()];
    public IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    public static Vector3f OFFSET_DOWN = new Vector3f(0.0f, -0.1875f, 0.0f);
    public static Vector3f OFFSET_UP = new Vector3f(0.0f, 0.1875f, 0.0f);
    public static Vector3f OFFSET_NORTH = new Vector3f(0.0f, 0.0f, -0.1875f);
    public static Vector3f OFFSET_WEST = new Vector3f(-0.1875f, 0.0f, 0.0f);
    public static Vector3f OFFSET_SOUTH = new Vector3f(0.0f, 0.0f, 0.1875f);
    public static Vector3f OFFSET_EAST = new Vector3f(0.1875f, 0.0f, 0.0f);
    public static final int CAPACITY = (Integer)Config.CONNECTOR_CAPACITY.get();
    public static final int MAX_IN = (Integer)Config.CONNECTOR_MAX_INPUT.get();
    public static final int MAX_OUT = (Integer)Config.CONNECTOR_MAX_OUTPUT.get();
    private EnergyNetwork network;
    private int demand = 0;

    public ConnectorTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, CAPACITY, MAX_IN, MAX_OUT);
    }

    @Override
    public IWireNode getNode(int node) {
        if (this.getNodeType(node) == null) {
            this.nodeCache[node] = null;
            return null;
        }
        if (this.nodeCache[node] == null) {
            this.nodeCache[node] = IWireNode.getWireNode(this.field_145850_b, this.getNodePos(node));
        }
        if (this.nodeCache[node] == null) {
            this.setNode(node, -1, null, null);
        }
        return this.nodeCache[node];
    }

    @Override
    public Vector3f getNodeOffset(int node) {
        switch ((Direction)this.func_195044_w().func_177229_b((Property)ConnectorBlock.FACING)) {
            case DOWN: {
                return OFFSET_DOWN;
            }
            case UP: {
                return OFFSET_UP;
            }
            case NORTH: {
                return OFFSET_NORTH;
            }
            case WEST: {
                return OFFSET_WEST;
            }
            case SOUTH: {
                return OFFSET_SOUTH;
            }
            case EAST: {
                return OFFSET_EAST;
            }
        }
        return OFFSET_DOWN;
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return this.func_195044_w().func_177229_b((Property)ConnectorBlock.FACING) == side;
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return this.func_195044_w().func_177229_b((Property)ConnectorBlock.FACING) == side;
    }

    @Override
    public int getNodeCount() {
        return 4;
    }

    @Override
    public int getNodeFromPos(Vector3d vector3d) {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public BlockPos getNodePos(int node) {
        return this.connectionPos[node];
    }

    @Override
    public WireType getNodeType(int node) {
        return this.connectionTypes[node];
    }

    @Override
    public int getOtherNodeIndex(int node) {
        if (this.connectionPos[node] == null) {
            return -1;
        }
        return this.connectionIndecies[node];
    }

    @Override
    public void setNode(int node, int other, BlockPos pos, WireType type) {
        this.connectionPos[node] = pos;
        this.connectionIndecies[node] = other;
        this.connectionTypes[node] = type;
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public void fromTag(BlockState state, CompoundNBT nbt, boolean clientPacket) {
        super.fromTag(state, nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!IWireNode.hasNode(nbt, i)) continue;
            this.readNode(nbt, i);
        }
    }

    @Override
    public void write(CompoundNBT nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) {
                IWireNode.clearNode(nbt, i);
                continue;
            }
            this.writeNode(nbt, i);
        }
    }

    @Override
    public void removeNode(int other) {
        IWireNode.super.removeNode(other);
        this.invalidateNodeCache();
        this.func_70296_d();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public BlockPos getMyPos() {
        return this.field_174879_c;
    }

    @Override
    public void func_145843_s() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            IWireNode node = this.getNode(i);
            node.removeNode(this.getOtherNodeIndex(i));
            node.invalidateNodeCache();
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.network != null) {
            this.network.invalidate();
        }
        super.func_145843_s();
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.awakeNetwork(this.field_145850_b)) {
            this.causeBlockUpdate();
        }
        this.networkTick(this.network);
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.network;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        this.network = network;
    }

    private void networkTick(EnergyNetwork en) {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        Direction d = (Direction)this.func_195044_w().func_177229_b((Property)ConnectorBlock.FACING);
        IEnergyStorage ies = this.getCachedEnergy(d);
        if (ies == null) {
            return;
        }
        int pull = en.pull(this.demand);
        ies.receiveEnergy(pull, false);
        int testExtract = this.energy.extractEnergy(Integer.MAX_VALUE, true);
        int testInsert = ies.receiveEnergy(MAX_OUT, true);
        this.demand = en.demand(testInsert);
        int push = en.push(testExtract);
        int ext = this.energy.internalConsumeEnergy(push);
    }

    @Override
    public void onObserved(ServerPlayerEntity player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.field_174879_c, this.getNetwork(0).getPulled(), this.getNetwork(0).getPushed(), player);
        }
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.field_174879_c, 0);
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("createaddition.tooltip.connector.info").func_240699_a_(TextFormatting.WHITE)));
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("createaddition.tooltip.energy.usage").func_240699_a_(TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_240702_b_(" ").func_240702_b_(Multimeter.format(EnergyNetworkPacket.clientBuff)).func_240702_b_("fe/t").func_240699_a_(TextFormatting.AQUA));
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

