/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.sound;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.sound.SoundScape;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class SoundScapes {
    static final int MAX_AMBIENT_SOURCE_DISTANCE = 16;
    static final int UPDATE_INTERVAL = 5;
    static final int SOUND_VOLUME_ARG_MAX = 15;
    private static Map<AmbienceGroup, Map<PitchGroup, Set<BlockPos>>> counter = new IdentityHashMap<AmbienceGroup, Map<PitchGroup, Set<BlockPos>>>();
    private static Map<Pair<AmbienceGroup, PitchGroup>, SoundScape> activeSounds = new HashMap<Pair<AmbienceGroup, PitchGroup>, SoundScape>();

    private static SoundScape kinetic(float pitch, AmbienceGroup group) {
        return new SoundScape(pitch, group).continuous(SoundEvents.field_187780_dr, 0.25f, 1.0f);
    }

    private static SoundScape cogwheel(float pitch, AmbienceGroup group) {
        return new SoundScape(pitch, group).continuous(AllSoundEvents.COGS.getMainEvent(), 1.5f, 1.0f);
    }

    private static SoundScape crushing(float pitch, AmbienceGroup group) {
        return new SoundScape(pitch, group).repeating(AllSoundEvents.CRUSHING_1.getMainEvent(), 1.545f, 0.75f, 1).repeating(AllSoundEvents.CRUSHING_2.getMainEvent(), 0.425f, 0.75f, 2).repeating(AllSoundEvents.CRUSHING_3.getMainEvent(), 2.0f, 1.75f, 2);
    }

    private static SoundScape milling(float pitch, AmbienceGroup group) {
        return new SoundScape(pitch, group).repeating(AllSoundEvents.CRUSHING_1.getMainEvent(), 1.545f, 0.75f, 1).repeating(AllSoundEvents.CRUSHING_2.getMainEvent(), 0.425f, 0.75f, 2);
    }

    public static void play(AmbienceGroup group, BlockPos pos, float pitch) {
        if (!((Boolean)AllConfigs.CLIENT.enableAmbientSounds.get()).booleanValue()) {
            return;
        }
        if (!SoundScapes.outOfRange(pos)) {
            SoundScapes.addSound(group, pos, pitch);
        }
    }

    public static void tick() {
        activeSounds.values().forEach(SoundScape::tick);
        if (AnimationTickHolder.getTicks() % 5 != 0) {
            return;
        }
        boolean disable = (Boolean)AllConfigs.CLIENT.enableAmbientSounds.get() == false;
        Iterator<Map.Entry<Pair<AmbienceGroup, PitchGroup>, SoundScape>> iterator = activeSounds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Pair<AmbienceGroup, PitchGroup>, SoundScape> entry = iterator.next();
            Pair<AmbienceGroup, PitchGroup> key = entry.getKey();
            SoundScape value = entry.getValue();
            if (!disable && SoundScapes.getSoundCount(key.getFirst(), key.getSecond()) != 0) continue;
            value.remove();
            iterator.remove();
        }
        counter.values().forEach(m -> m.values().forEach(Set::clear));
    }

    private static void addSound(AmbienceGroup group, BlockPos pos, float pitch) {
        PitchGroup groupFromPitch = SoundScapes.getGroupFromPitch(pitch);
        Set set = counter.computeIfAbsent(group, ag -> new IdentityHashMap()).computeIfAbsent(groupFromPitch, pg -> new HashSet());
        set.add(pos);
        Pair<AmbienceGroup, PitchGroup> pair = Pair.of(group, groupFromPitch);
        activeSounds.computeIfAbsent(pair, $ -> {
            SoundScape soundScape = group.instantiate(pitch);
            soundScape.play();
            return soundScape;
        });
    }

    public static void invalidateAll() {
        counter.clear();
        activeSounds.forEach(($, sound) -> sound.remove());
        activeSounds.clear();
    }

    protected static boolean outOfRange(BlockPos pos) {
        return !SoundScapes.getCameraPos().func_218141_a((Vector3i)pos, 16.0);
    }

    protected static BlockPos getCameraPos() {
        Entity renderViewEntity = Minecraft.func_71410_x().field_175622_Z;
        if (renderViewEntity == null) {
            return BlockPos.field_177992_a;
        }
        BlockPos playerLocation = renderViewEntity.func_233580_cy_();
        return playerLocation;
    }

    public static int getSoundCount(AmbienceGroup group, PitchGroup pitchGroup) {
        return SoundScapes.getAllLocations(group, pitchGroup).size();
    }

    public static Set<BlockPos> getAllLocations(AmbienceGroup group, PitchGroup pitchGroup) {
        return counter.getOrDefault((Object)group, Collections.emptyMap()).getOrDefault((Object)pitchGroup, Collections.emptySet());
    }

    public static PitchGroup getGroupFromPitch(float pitch) {
        if ((double)pitch < 0.7) {
            return PitchGroup.VERY_LOW;
        }
        if ((double)pitch < 0.9) {
            return PitchGroup.LOW;
        }
        if ((double)pitch < 1.1) {
            return PitchGroup.NORMAL;
        }
        if ((double)pitch < 1.3) {
            return PitchGroup.HIGH;
        }
        return PitchGroup.VERY_HIGH;
    }

    static enum PitchGroup {
        VERY_LOW,
        LOW,
        NORMAL,
        HIGH,
        VERY_HIGH;

    }

    public static enum AmbienceGroup {
        KINETIC((x$0, x$1) -> SoundScapes.access$300(x$0, x$1)),
        COG((x$0, x$1) -> SoundScapes.access$200(x$0, x$1)),
        CRUSHING((x$0, x$1) -> SoundScapes.access$100(x$0, x$1)),
        MILLING((x$0, x$1) -> SoundScapes.access$000(x$0, x$1));

        private BiFunction<Float, AmbienceGroup, SoundScape> factory;

        private AmbienceGroup(BiFunction<Float, AmbienceGroup, SoundScape> factory) {
            this.factory = factory;
        }

        public SoundScape instantiate(float pitch) {
            return this.factory.apply(Float.valueOf(pitch), this);
        }
    }
}

