/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.VirtualEmptyModelData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.foundation.render.Compartment;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class SuperByteBufferCache {
    private Map<Compartment<?>, Cache<Object, SuperByteBuffer>> cache = new HashMap();

    public SuperByteBufferCache() {
        this.registerCompartment(Compartment.GENERIC_TILE);
        this.registerCompartment(Compartment.PARTIAL);
        this.registerCompartment(Compartment.DIRECTIONAL_PARTIAL);
    }

    public SuperByteBuffer renderBlock(BlockState toRender) {
        return this.getGeneric(toRender, () -> this.standardBlockRender(toRender));
    }

    public SuperByteBuffer renderPartial(PartialModel partial, BlockState referenceState) {
        return this.get(Compartment.PARTIAL, partial, () -> this.standardModelRender(partial.get(), referenceState));
    }

    public SuperByteBuffer renderPartial(PartialModel partial, BlockState referenceState, Supplier<MatrixStack> modelTransform) {
        return this.get(Compartment.PARTIAL, partial, () -> this.standardModelRender(partial.get(), referenceState, (MatrixStack)modelTransform.get()));
    }

    public SuperByteBuffer renderDirectionalPartial(PartialModel partial, BlockState referenceState, Direction dir) {
        return this.get(Compartment.DIRECTIONAL_PARTIAL, Pair.of((Object)dir, (Object)partial), () -> this.standardModelRender(partial.get(), referenceState));
    }

    public SuperByteBuffer renderDirectionalPartial(PartialModel partial, BlockState referenceState, Direction dir, Supplier<MatrixStack> modelTransform) {
        return this.get(Compartment.DIRECTIONAL_PARTIAL, Pair.of((Object)dir, (Object)partial), () -> this.standardModelRender(partial.get(), referenceState, (MatrixStack)modelTransform.get()));
    }

    public SuperByteBuffer renderBlockIn(Compartment<BlockState> compartment, BlockState toRender) {
        return this.get(compartment, toRender, () -> this.standardBlockRender(toRender));
    }

    SuperByteBuffer getGeneric(BlockState key, Supplier<SuperByteBuffer> supplier) {
        return this.get(Compartment.GENERIC_TILE, key, supplier);
    }

    public <T> SuperByteBuffer get(Compartment<T> compartment, T key, Supplier<SuperByteBuffer> supplier) {
        Cache<Object, SuperByteBuffer> compartmentCache = this.cache.get(compartment);
        try {
            return (SuperByteBuffer)compartmentCache.get(key, supplier::get);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> void invalidate(Compartment<T> compartment, T key) {
        Cache<Object, SuperByteBuffer> compartmentCache = this.cache.get(compartment);
        compartmentCache.invalidate(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCompartment(Compartment<?> instance) {
        Map<Compartment<?>, Cache<Object, SuperByteBuffer>> map = this.cache;
        synchronized (map) {
            this.cache.put(instance, (Cache<Object, SuperByteBuffer>)CacheBuilder.newBuilder().build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCompartment(Compartment<?> instance, long ticksUntilExpired) {
        Map<Compartment<?>, Cache<Object, SuperByteBuffer>> map = this.cache;
        synchronized (map) {
            this.cache.put(instance, (Cache<Object, SuperByteBuffer>)CacheBuilder.newBuilder().expireAfterAccess(ticksUntilExpired * 50L, TimeUnit.MILLISECONDS).build());
        }
    }

    private SuperByteBuffer standardBlockRender(BlockState renderedState) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        return this.standardModelRender(dispatcher.func_184389_a(renderedState), renderedState);
    }

    private SuperByteBuffer standardModelRender(IBakedModel model, BlockState referenceState) {
        return this.standardModelRender(model, referenceState, new MatrixStack());
    }

    private SuperByteBuffer standardModelRender(IBakedModel model, BlockState referenceState, MatrixStack ms) {
        BufferBuilder builder = SuperByteBufferCache.getBufferBuilder(model, referenceState, ms);
        return new SuperByteBuffer(builder);
    }

    public static BufferBuilder getBufferBuilder(IBakedModel model, BlockState referenceState, MatrixStack ms) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
        BufferBuilder builder = new BufferBuilder(512);
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        blockRenderer.renderModel((IBlockDisplayReader)mc.field_71441_e, model, referenceState, BlockPos.field_177992_a.func_177981_b(255), ms, (IVertexBuilder)builder, true, mc.field_71441_e.field_73012_v, 42L, OverlayTexture.field_229196_a_, (IModelData)VirtualEmptyModelData.INSTANCE);
        builder.func_178977_d();
        return builder;
    }

    public void invalidate() {
        this.cache.forEach((comp, cache) -> cache.invalidateAll());
    }
}

