/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data.recipe;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.data.recipe.CompactingRecipeGen;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.data.recipe.CrushingRecipeGen;
import com.simibubi.create.foundation.data.recipe.CuttingRecipeGen;
import com.simibubi.create.foundation.data.recipe.DeployingRecipeGen;
import com.simibubi.create.foundation.data.recipe.EmptyingRecipeGen;
import com.simibubi.create.foundation.data.recipe.FillingRecipeGen;
import com.simibubi.create.foundation.data.recipe.MillingRecipeGen;
import com.simibubi.create.foundation.data.recipe.MixingRecipeGen;
import com.simibubi.create.foundation.data.recipe.PolishingRecipeGen;
import com.simibubi.create.foundation.data.recipe.PressingRecipeGen;
import com.simibubi.create.foundation.data.recipe.WashingRecipeGen;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public abstract class ProcessingRecipeGen
extends CreateRecipeProvider {
    protected static final List<ProcessingRecipeGen> GENERATORS = new ArrayList<ProcessingRecipeGen>();
    protected static final int BUCKET = 1000;
    protected static final int BOTTLE = 250;

    public static void registerAll(DataGenerator gen) {
        GENERATORS.add(new CrushingRecipeGen(gen));
        GENERATORS.add(new MillingRecipeGen(gen));
        GENERATORS.add(new CuttingRecipeGen(gen));
        GENERATORS.add(new WashingRecipeGen(gen));
        GENERATORS.add(new PolishingRecipeGen(gen));
        GENERATORS.add(new DeployingRecipeGen(gen));
        GENERATORS.add(new MixingRecipeGen(gen));
        GENERATORS.add(new CompactingRecipeGen(gen));
        GENERATORS.add(new PressingRecipeGen(gen));
        GENERATORS.add(new FillingRecipeGen(gen));
        GENERATORS.add(new EmptyingRecipeGen(gen));
        gen.func_200390_a(new IDataProvider(){

            public String func_200397_b() {
                return "Create's Processing Recipes";
            }

            public void func_200398_a(DirectoryCache dc) throws IOException {
                GENERATORS.forEach(g -> {
                    try {
                        g.func_200398_a(dc);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        });
    }

    public ProcessingRecipeGen(DataGenerator generator) {
        super(generator);
    }

    protected <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(String namespace, Supplier<IItemProvider> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        CreateRecipeProvider.GeneratedRecipe generatedRecipe = c -> {
            IItemProvider iItemProvider = (IItemProvider)singleIngredient.get();
            ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), new ResourceLocation(namespace, iItemProvider.func_199767_j().getRegistryName().func_110623_a())).withItemIngredients(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{iItemProvider})))).build(c);
        };
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(Supplier<IItemProvider> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create("create", singleIngredient, transform);
    }

    protected <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(ResourceLocation name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        CreateRecipeProvider.GeneratedRecipe generatedRecipe = c -> ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), name))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create(Create.asResource(name), transform);
    }

    protected abstract IRecipeTypeInfo getRecipeType();

    protected <T extends ProcessingRecipe<?>> ProcessingRecipeSerializer<T> getSerializer() {
        return (ProcessingRecipeSerializer)((Object)this.getRecipeType().getSerializer());
    }

    public String func_200397_b() {
        return "Create's Processing Recipes: " + this.getRecipeType().getId().func_110623_a();
    }
}

