/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.armor;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.particle.AirParticleData;
import com.simibubi.create.content.curiosities.armor.BackTankUtil;
import com.simibubi.create.content.curiosities.armor.CopperArmorItem;
import com.simibubi.create.foundation.tileEntity.ComparatorUtil;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CopperBacktankTileEntity
extends KineticTileEntity
implements INameable {
    public int airLevel;
    public int airLevelTimer;
    private ITextComponent customName;
    private int capacityEnchantLevel;
    private ListNBT enchantmentTag = new ListNBT();

    public CopperBacktankTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    @Override
    public void func_73660_a() {
        BooleanProperty waterProperty;
        super.func_73660_a();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        BlockState state = this.func_195044_w();
        if (state.func_235901_b_((Property)(waterProperty = BlockStateProperties.field_208198_y)) && ((Boolean)state.func_177229_b((Property)waterProperty)).booleanValue()) {
            return;
        }
        if (this.airLevelTimer > 0) {
            --this.airLevelTimer;
            return;
        }
        int max = BackTankUtil.maxAir(this.capacityEnchantLevel);
        if (this.field_145850_b.field_72995_K) {
            Vector3d centerOf = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
            Vector3d v = VecHelper.offsetRandomly(centerOf, Create.RANDOM, 0.65f);
            Vector3d m = centerOf.func_178788_d(v);
            if (this.airLevel != max) {
                this.field_145850_b.func_195594_a((IParticleData)new AirParticleData(1.0f, 0.05f), v.field_72450_a, v.field_72448_b, v.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
            }
            return;
        }
        if (this.airLevel == max) {
            return;
        }
        int prevComparatorLevel = this.getComparatorOutput();
        float abs = Math.abs(this.getSpeed());
        int increment = MathHelper.func_76125_a((int)(((int)abs - 100) / 20), (int)1, (int)5);
        this.airLevel = Math.min(max, this.airLevel + increment);
        if (this.getComparatorOutput() != prevComparatorLevel && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175666_e(this.field_174879_c, state.func_177230_c());
        }
        if (this.airLevel == max) {
            this.sendData();
        }
        this.airLevelTimer = MathHelper.func_76125_a((int)((int)(128.0f - abs / 5.0f) - 108), (int)0, (int)20);
    }

    public int getComparatorOutput() {
        int max = BackTankUtil.maxAir(this.capacityEnchantLevel);
        return ComparatorUtil.fractionToRedstoneLevel((float)this.airLevel / (float)max);
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_74768_a("Air", this.airLevel);
        compound.func_74768_a("Timer", this.airLevelTimer);
        compound.func_74768_a("CapacityEnchantment", this.capacityEnchantLevel);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_218657_a("Enchantments", (INBT)this.enchantmentTag);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        int prev = this.airLevel;
        this.capacityEnchantLevel = compound.func_74762_e("CapacityEnchantment");
        this.airLevel = compound.func_74762_e("Air");
        this.airLevelTimer = compound.func_74762_e("Timer");
        this.enchantmentTag = compound.func_150295_c("Enchantments", 10);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        if (prev != 0 && prev != this.airLevel && this.airLevel == BackTankUtil.maxAir(this.capacityEnchantLevel) && clientPacket) {
            this.playFilledEffect();
        }
    }

    protected void playFilledEffect() {
        AllSoundEvents.CONFIRM.playAt(this.field_145850_b, this.field_174879_c, 0.4f, 1.0f, true);
        Vector3d baseMotion = new Vector3d(0.25, 0.1, 0.0);
        Vector3d baseVec = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        for (int i = 0; i < 360; i += 10) {
            Vector3d m = VecHelper.rotate(baseMotion, i, Direction.Axis.Y);
            Vector3d v = baseVec.func_178787_e(m.func_72432_b().func_186678_a(0.25));
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197602_M, v.field_72450_a, v.field_72448_b, v.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
        }
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : new TranslationTextComponent(((CopperArmorItem)((Object)AllItems.COPPER_BACKTANK.get())).func_77658_a());
    }

    public boolean shouldRenderNormally() {
        return true;
    }

    public int getAirLevel() {
        return this.airLevel;
    }

    public void setAirLevel(int airLevel) {
        this.airLevel = airLevel;
        this.sendData();
    }

    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ListNBT getEnchantmentTag() {
        return this.enchantmentTag;
    }

    public void setEnchantmentTag(ListNBT enchantmentTag) {
        this.enchantmentTag = enchantmentTag;
    }

    public void setCapacityEnchantLevel(int capacityEnchantLevel) {
        this.capacityEnchantLevel = capacityEnchantLevel;
    }
}

