/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.armor;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.config.AllConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BackTankUtil {
    public static ItemStack get(LivingEntity entity) {
        for (ItemStack itemStack : entity.func_184193_aE()) {
            if (!AllItems.COPPER_BACKTANK.isIn(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasAirRemaining(ItemStack backtank) {
        return BackTankUtil.getAir(backtank) > 0.0f;
    }

    public static float getAir(ItemStack backtank) {
        CompoundNBT tag = backtank.func_196082_o();
        return Math.min(tag.func_74760_g("Air"), (float)BackTankUtil.maxAir(backtank));
    }

    public static void consumeAir(ItemStack backtank, float i) {
        CompoundNBT tag = backtank.func_196082_o();
        tag.func_74776_a("Air", Math.min(BackTankUtil.getAir(backtank) - i, (float)BackTankUtil.maxAir(backtank)));
        backtank.func_77982_d(tag);
    }

    public static int maxAir(ItemStack backtank) {
        return BackTankUtil.maxAir(EnchantmentHelper.func_77506_a((Enchantment)AllEnchantments.CAPACITY.get(), (ItemStack)backtank));
    }

    public static int maxAir(int enchantLevel) {
        return (Integer)AllConfigs.SERVER.curiosities.airInBacktank.get() + (Integer)AllConfigs.SERVER.curiosities.enchantedBacktankCapacity.get() * enchantLevel;
    }

    public static int maxAirWithoutEnchants() {
        return (Integer)AllConfigs.SERVER.curiosities.airInBacktank.get();
    }

    public static boolean canAbsorbDamage(LivingEntity entity, int usesPerTank) {
        if (usesPerTank == 0) {
            return true;
        }
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_()) {
            return true;
        }
        ItemStack backtank = BackTankUtil.get(entity);
        if (backtank.func_190926_b()) {
            return false;
        }
        if (!BackTankUtil.hasAirRemaining(backtank)) {
            return false;
        }
        float cost = (float)BackTankUtil.maxAirWithoutEnchants() / (float)usesPerTank;
        BackTankUtil.consumeAir(backtank, cost);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getRGBDurabilityForDisplay(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 0;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return 0;
        }
        ItemStack backtank = BackTankUtil.get((LivingEntity)player);
        if (backtank.func_190926_b() || !BackTankUtil.hasAirRemaining(backtank)) {
            return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - BackTankUtil.getDurabilityForDisplay(stack, usesPerTank))) / 3.0f), (float)1.0f, (float)1.0f);
        }
        return backtank.func_77973_b().getRGBDurabilityForDisplay(backtank);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static double getDurabilityForDisplay(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 0.0;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return 0.0;
        }
        ItemStack backtank = BackTankUtil.get((LivingEntity)player);
        if (backtank.func_190926_b() || !BackTankUtil.hasAirRemaining(backtank)) {
            return (double)stack.func_77952_i() / (double)stack.func_77958_k();
        }
        return backtank.func_77973_b().getDurabilityForDisplay(backtank);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean showDurabilityBar(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return false;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        ItemStack backtank = BackTankUtil.get((LivingEntity)player);
        if (backtank.func_190926_b() || !BackTankUtil.hasAirRemaining(backtank)) {
            return stack.func_77951_h();
        }
        return true;
    }
}

