/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.fluids.actors.FluidSplashPacket;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidManipulationBehaviour
extends TileEntityBehaviour {
    MutableBoundingBox affectedArea;
    BlockPos rootPos;
    boolean infinite;
    protected boolean counterpartActed;
    static final int searchedPerTick = 256;
    static final int validationTimerMin = 160;
    List<BlockPosEntry> frontier;
    Set<BlockPos> visited;
    int revalidateIn;

    public FluidManipulationBehaviour(SmartTileEntity te) {
        super(te);
        this.setValidationTimer();
        this.infinite = false;
        this.visited = new HashSet<BlockPos>();
        this.frontier = new ArrayList<BlockPosEntry>();
    }

    public void counterpartActed() {
        this.counterpartActed = true;
    }

    protected int validationTimer() {
        int maxBlocks = this.maxBlocks();
        return maxBlocks < 0 ? 160 : Math.max(160, maxBlocks / 256 + 1);
    }

    protected int setValidationTimer() {
        this.revalidateIn = this.validationTimer();
        return this.revalidateIn;
    }

    protected int setLongValidationTimer() {
        this.revalidateIn = this.validationTimer() * 2;
        return this.revalidateIn;
    }

    protected int maxRange() {
        return (Integer)AllConfigs.SERVER.fluids.hosePulleyRange.get();
    }

    protected int maxBlocks() {
        return (Integer)AllConfigs.SERVER.fluids.hosePulleyBlockThreshold.get();
    }

    protected boolean fillInfinite() {
        return (Boolean)AllConfigs.SERVER.fluids.fillInfinite.get();
    }

    public void reset() {
        if (this.affectedArea != null) {
            this.scheduleUpdatesInAffectedArea();
        }
        this.affectedArea = null;
        this.setValidationTimer();
        this.frontier.clear();
        this.visited.clear();
        this.infinite = false;
    }

    @Override
    public void destroy() {
        this.reset();
        super.destroy();
    }

    protected void scheduleUpdatesInAffectedArea() {
        World world = this.getWorld();
        BlockPos.func_218281_b((BlockPos)new BlockPos(this.affectedArea.field_78897_a - 1, this.affectedArea.field_78895_b - 1, this.affectedArea.field_78896_c - 1), (BlockPos)new BlockPos(this.affectedArea.field_78893_d + 1, this.affectedArea.field_78894_e + 1, this.affectedArea.field_78892_f + 1)).forEach(pos -> {
            FluidState nextFluidState = world.func_204610_c(pos);
            if (nextFluidState.func_206888_e()) {
                return;
            }
            world.func_205219_F_().func_205360_a(pos, (Object)nextFluidState.func_206886_c(), world.func_201674_k().nextInt(5));
        });
    }

    protected int comparePositions(BlockPosEntry e1, BlockPosEntry e2) {
        Vector3d centerOfRoot = VecHelper.getCenterOf((Vector3i)this.rootPos);
        BlockPos pos2 = e2.pos;
        BlockPos pos1 = e1.pos;
        if (pos1.func_177956_o() != pos2.func_177956_o()) {
            return Integer.compare(pos2.func_177956_o(), pos1.func_177956_o());
        }
        int compareDistance = Integer.compare(e2.distance, e1.distance);
        if (compareDistance != 0) {
            return compareDistance;
        }
        return Double.compare(VecHelper.getCenterOf((Vector3i)pos2).func_72436_e(centerOfRoot), VecHelper.getCenterOf((Vector3i)pos1).func_72436_e(centerOfRoot));
    }

    protected Fluid search(Fluid fluid, List<BlockPosEntry> frontier, Set<BlockPos> visited, BiConsumer<BlockPos, Integer> add, boolean searchDownward) {
        World world = this.getWorld();
        int maxBlocks = this.maxBlocks();
        int maxRange = this.canDrainInfinitely(fluid) ? this.maxRange() : this.maxRange() / 2;
        int maxRangeSq = maxRange * maxRange;
        for (int i = 0; !(i >= 256 || frontier.isEmpty() || visited.size() > maxBlocks && this.canDrainInfinitely(fluid)); ++i) {
            BlockPosEntry entry = frontier.remove(0);
            BlockPos currentPos = entry.pos;
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            FluidState fluidState = world.func_204610_c(currentPos);
            if (fluidState.func_206888_e()) continue;
            Fluid currentFluid = FluidHelper.convertToStill(fluidState.func_206886_c());
            if (fluid == null) {
                fluid = currentFluid;
            }
            if (!currentFluid.func_207187_a(fluid)) continue;
            add.accept(currentPos, entry.distance);
            for (Direction side : Iterate.directions) {
                Fluid nextFluid;
                FluidState nextFluidState;
                BlockPos offsetPos;
                if (!searchDownward && side == Direction.DOWN || visited.contains(offsetPos = currentPos.func_177972_a(side)) || offsetPos.func_177951_i((Vector3i)this.rootPos) > (double)maxRangeSq || (nextFluidState = world.func_204610_c(offsetPos)).func_206888_e() || (nextFluid = nextFluidState.func_206886_c()) == FluidHelper.convertToFlowing(nextFluid) && side == Direction.UP && !VecHelper.onSameAxis(this.rootPos, offsetPos, Direction.Axis.Y)) continue;
                frontier.add(new BlockPosEntry(offsetPos, entry.distance + 1));
            }
        }
        return fluid;
    }

    protected void playEffect(World world, BlockPos pos, Fluid fluid, boolean fillSound) {
        SoundEvent soundevent;
        BlockPos splooshPos = pos == null ? this.tileEntity.func_174877_v() : pos;
        SoundEvent soundEvent = soundevent = fillSound ? fluid.getAttributes().getFillSound() : fluid.getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? (fillSound ? SoundEvents.field_187633_N : SoundEvents.field_187627_L) : (fillSound ? SoundEvents.field_187630_M : SoundEvents.field_187624_K);
        }
        world.func_184133_a(null, splooshPos, soundevent, SoundCategory.BLOCKS, 0.3f, 1.0f);
        if (world instanceof ServerWorld) {
            AllPackets.sendToNear(world, splooshPos, 10, new FluidSplashPacket(splooshPos, new FluidStack(fluid, 1)));
        }
    }

    protected boolean canDrainInfinitely(Fluid fluid) {
        return this.maxBlocks() != -1 && !AllTags.AllFluidTags.NO_INFINITE_DRAINING.matches(fluid);
    }

    @Override
    public void write(CompoundNBT nbt, boolean clientPacket) {
        if (this.rootPos != null) {
            nbt.func_218657_a("LastPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.rootPos));
        }
        if (this.affectedArea != null) {
            nbt.func_218657_a("AffectedAreaFrom", (INBT)NBTUtil.func_186859_a((BlockPos)new BlockPos(this.affectedArea.field_78897_a, this.affectedArea.field_78895_b, this.affectedArea.field_78896_c)));
            nbt.func_218657_a("AffectedAreaTo", (INBT)NBTUtil.func_186859_a((BlockPos)new BlockPos(this.affectedArea.field_78893_d, this.affectedArea.field_78894_e, this.affectedArea.field_78892_f)));
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundNBT nbt, boolean clientPacket) {
        if (nbt.func_74764_b("LastPos")) {
            this.rootPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("LastPos"));
        }
        if (nbt.func_74764_b("AffectedAreaFrom") && nbt.func_74764_b("AffectedAreaTo")) {
            this.affectedArea = new MutableBoundingBox((Vector3i)NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("AffectedAreaFrom")), (Vector3i)NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("AffectedAreaTo")));
        }
        super.read(nbt, clientPacket);
    }

    protected static class BlockPosEntry {
        public BlockPos pos;
        public int distance;

        public BlockPosEntry(BlockPos pos, int distance) {
            this.pos = pos;
            this.distance = distance;
        }
    }
}

