/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.chassis;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.AbstractChassisBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class LinearChassisBlock
extends AbstractChassisBlock {
    public static final BooleanProperty STICKY_TOP = BooleanProperty.func_177716_a((String)"sticky_top");
    public static final BooleanProperty STICKY_BOTTOM = BooleanProperty.func_177716_a((String)"sticky_bottom");

    public LinearChassisBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)STICKY_TOP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)STICKY_BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STICKY_TOP, STICKY_BOTTOM});
        super.func_206840_a(builder);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos placedOnPos = context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d());
        BlockState blockState = context.func_195991_k().func_180495_p(placedOnPos);
        if (context.func_195999_j() == null || !context.func_195999_j().func_225608_bj_()) {
            if (LinearChassisBlock.isChassis(blockState)) {
                return (BlockState)this.func_176223_P().func_206870_a((Property)field_176298_M, blockState.func_177229_b((Property)field_176298_M));
            }
            return (BlockState)this.func_176223_P().func_206870_a((Property)field_176298_M, (Comparable)context.func_196010_d().func_176740_k());
        }
        return super.func_196258_a(context);
    }

    public BlockState func_196271_a(BlockState state, Direction side, BlockState other, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        BooleanProperty property = this.getGlueableSide(state, side);
        if (property == null || !LinearChassisBlock.sameKind(state, other) || state.func_177229_b((Property)field_176298_M) != other.func_177229_b((Property)field_176298_M)) {
            return state;
        }
        return (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BooleanProperty getGlueableSide(BlockState state, Direction face) {
        if (face.func_176740_k() != state.func_177229_b((Property)field_176298_M)) {
            return null;
        }
        return face.func_176743_c() == Direction.AxisDirection.POSITIVE ? STICKY_TOP : STICKY_BOTTOM;
    }

    @Override
    protected boolean glueAllowedOnSide(IBlockReader world, BlockPos pos, BlockState state, Direction side) {
        BlockState other = world.func_180495_p(pos.func_177972_a(side));
        return !LinearChassisBlock.sameKind(other, state) || state.func_177229_b((Property)field_176298_M) != other.func_177229_b((Property)field_176298_M);
    }

    public static boolean isChassis(BlockState state) {
        return AllBlocks.LINEAR_CHASSIS.has(state) || AllBlocks.SECONDARY_LINEAR_CHASSIS.has(state);
    }

    public static boolean sameKind(BlockState state1, BlockState state2) {
        return state1.func_177230_c() == state2.func_177230_c();
    }

    public static class ChassisCTBehaviour
    extends ConnectedTextureBehaviour {
        @Override
        public CTSpriteShiftEntry get(BlockState state, Direction direction) {
            Block block = state.func_177230_c();
            BooleanProperty glueableSide = ((LinearChassisBlock)block).getGlueableSide(state, direction);
            if (glueableSide == null) {
                return AllBlocks.LINEAR_CHASSIS.has(state) ? AllSpriteShifts.CHASSIS_SIDE : AllSpriteShifts.SECONDARY_CHASSIS_SIDE;
            }
            return (Boolean)state.func_177229_b((Property)glueableSide) != false ? AllSpriteShifts.CHASSIS_STICKY : AllSpriteShifts.CHASSIS;
        }

        @Override
        protected Direction getUpDirection(IBlockDisplayReader reader, BlockPos pos, BlockState state, Direction face) {
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M);
            if (face.func_176740_k() == axis) {
                return super.getUpDirection(reader, pos, state, face);
            }
            return Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        }

        @Override
        protected Direction getRightDirection(IBlockDisplayReader reader, BlockPos pos, BlockState state, Direction face) {
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M);
            return axis != face.func_176740_k() && axis.func_176722_c() ? (face.func_176740_k().func_176722_c() ? Direction.DOWN : (axis == Direction.Axis.X ? Direction.NORTH : Direction.EAST)) : super.getRightDirection(reader, pos, state, face);
        }

        @Override
        protected boolean reverseUVsHorizontally(BlockState state, Direction face) {
            boolean side;
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M);
            boolean bl = side = face.func_176740_k() != axis;
            if (side && axis == Direction.Axis.X && face.func_176740_k().func_176722_c()) {
                return true;
            }
            return super.reverseUVsHorizontally(state, face);
        }

        @Override
        protected boolean reverseUVsVertically(BlockState state, Direction face) {
            return super.reverseUVsVertically(state, face);
        }

        @Override
        public boolean reverseUVs(BlockState state, Direction face) {
            boolean end;
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M);
            boolean bl = end = face.func_176740_k() == axis;
            if (end && axis.func_176722_c() && face.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                return true;
            }
            if (!end && axis.func_176722_c() && face == Direction.DOWN) {
                return true;
            }
            return super.reverseUVs(state, face);
        }

        @Override
        public boolean connectsTo(BlockState state, BlockState other, IBlockDisplayReader reader, BlockPos pos, BlockPos otherPos, Direction face) {
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M);
            boolean superConnect = face.func_176740_k() == axis ? super.connectsTo(state, other, reader, pos, otherPos, face) : LinearChassisBlock.sameKind(state, other);
            return superConnect && axis == other.func_177229_b((Property)RotatedPillarBlock.field_176298_M);
        }
    }
}

