/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.OrientedData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.BackHalfShaftInstance;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class BearingInstance<B extends KineticTileEntity>
extends BackHalfShaftInstance
implements IDynamicInstance {
    final B bearing;
    final OrientedData topInstance;
    final Vector3f rotationAxis;
    final Quaternion blockOrientation;

    public BearingInstance(MaterialManager<?> modelManager, B tile) {
        super(modelManager, (KineticTileEntity)tile);
        this.bearing = tile;
        Direction facing = (Direction)this.blockState.func_177229_b((Property)BlockStateProperties.field_208155_H);
        this.rotationAxis = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis).func_229386_k_();
        this.blockOrientation = BearingInstance.getBlockStateOrientation(facing);
        PartialModel top = ((IBearingTileEntity)this.bearing).isWoodenTop() ? AllBlockPartials.BEARING_TOP_WOODEN : AllBlockPartials.BEARING_TOP;
        this.topInstance = (OrientedData)this.getOrientedMaterial().getModel(top, this.blockState).createInstance();
        this.topInstance.setPosition(this.getInstancePosition()).setRotation(this.blockOrientation);
    }

    public void beginFrame() {
        float interpolatedAngle = ((IBearingTileEntity)this.bearing).getInterpolatedAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        Quaternion rot = this.rotationAxis.func_229187_a_(interpolatedAngle);
        rot.func_195890_a(this.blockOrientation);
        this.topInstance.setRotation(rot);
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new IFlatLight[]{this.topInstance});
    }

    @Override
    public void remove() {
        super.remove();
        this.topInstance.delete();
    }

    static Quaternion getBlockStateOrientation(Direction facing) {
        Quaternion orientation = facing.func_176740_k().func_176722_c() ? Vector3f.field_229181_d_.func_229187_a_(AngleHelper.horizontalAngle(facing.func_176734_d())) : Quaternion.field_227060_a_.func_227068_g_();
        orientation.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(-90.0f - AngleHelper.verticalAngle(facing)));
        return orientation;
    }
}

