/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class DeployerItemHandler
implements IItemHandlerModifiable {
    private DeployerTileEntity te;
    private DeployerFakePlayer player;

    public DeployerItemHandler(DeployerTileEntity te) {
        this.te = te;
        this.player = te.player;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getHeld();
    }

    public ItemStack getHeld() {
        if (this.player == null) {
            return ItemStack.field_190927_a;
        }
        return this.player.func_184614_ca();
    }

    public void set(ItemStack stack) {
        if (this.player == null) {
            return;
        }
        if (this.te.func_145831_w().field_72995_K) {
            return;
        }
        this.player.func_184611_a(Hand.MAIN_HAND, stack);
        this.te.func_70296_d();
        this.te.sendData();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack held = this.getHeld();
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (held.func_190926_b()) {
            if (!simulate) {
                this.set(stack);
            }
            return ItemStack.field_190927_a;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)held, (ItemStack)stack)) {
            return stack;
        }
        int space = held.func_77976_d() - held.func_190916_E();
        ItemStack remainder = stack.func_77946_l();
        ItemStack split = remainder.func_77979_a(space);
        if (space == 0) {
            return stack;
        }
        if (!simulate) {
            held = held.func_77946_l();
            held.func_190920_e(held.func_190916_E() + split.func_190916_E());
            this.set(held);
        }
        return remainder;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack extractedFromOverflow = ItemStack.field_190927_a;
        ItemStack returnToOverflow = ItemStack.field_190927_a;
        Iterator<ItemStack> iterator = this.te.overflowItems.iterator();
        while (iterator.hasNext()) {
            ItemStack existing = iterator.next();
            if (existing.func_190926_b()) {
                iterator.remove();
                continue;
            }
            int toExtract = Math.min(amount, existing.func_77976_d());
            if (existing.func_190916_E() <= toExtract) {
                if (!simulate) {
                    iterator.remove();
                }
                extractedFromOverflow = existing;
                break;
            }
            if (!simulate) {
                iterator.remove();
                returnToOverflow = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract));
            }
            extractedFromOverflow = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
            break;
        }
        if (!returnToOverflow.func_190926_b()) {
            this.te.overflowItems.add(returnToOverflow);
        }
        if (!extractedFromOverflow.func_190926_b()) {
            return extractedFromOverflow;
        }
        ItemStack held = this.getHeld();
        if (amount == 0 || held.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.te.filtering.getFilter().func_190926_b() && this.te.filtering.test(held)) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            return held.func_77946_l().func_77979_a(amount);
        }
        ItemStack toReturn = held.func_77979_a(amount);
        this.te.func_70296_d();
        this.te.sendData();
        return toReturn;
    }

    public int getSlotLimit(int slot) {
        return Math.min(this.getHeld().func_77976_d(), 64);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        FilteringBehaviour filteringBehaviour = this.te.getBehaviour(FilteringBehaviour.TYPE);
        return filteringBehaviour == null || filteringBehaviour.test(stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.set(stack);
    }
}

