/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.actors.DrillBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;

public class DrillRenderer
extends KineticTileEntityRenderer {
    public DrillRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return PartialBufferer.getFacing(AllBlockPartials.DRILL_HEAD, te.func_195044_w());
    }

    public static void renderInContraption(MovementContext context, PlacementSimulationWorld renderWorld, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        BlockState state = context.state;
        SuperByteBuffer superBuffer = PartialBufferer.get(AllBlockPartials.DRILL_HEAD, state);
        Direction facing = (Direction)state.func_177229_b((Property)DrillBlock.FACING);
        float speed = context.contraption.stalled || !VecHelper.isVecPointingTowards(context.relativeMotion, facing.func_176734_d()) ? context.getAnimationSpeed() : 0.0f;
        float time = AnimationTickHolder.getRenderTime() / 20.0f;
        float angle = time * speed % 360.0f;
        MatrixStack m = matrices.getModel();
        m.func_227860_a_();
        MatrixTransformStack.of((MatrixStack)m).centre().rotateY((double)AngleHelper.horizontalAngle(facing)).rotateX((double)AngleHelper.verticalAngle(facing)).rotateZ((double)angle).unCentre();
        superBuffer.transform(m).light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), buffer.getBuffer(RenderType.func_228639_c_()));
        m.func_227865_b_();
    }
}

