/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.content.contraptions.components.fan.SplashingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.GuiGameElement;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;

public class FanWashingCategory
extends ProcessingViaFanCategory<SplashingRecipe> {
    public FanWashingCategory() {
        super(185, FanWashingCategory.doubleItemIcon((IItemProvider)AllItems.PROPELLER.get(), (IItemProvider)Items.field_151131_as));
    }

    public Class<? extends SplashingRecipe> getRecipeClass() {
        return SplashingRecipe.class;
    }

    @Override
    public void setIngredients(SplashingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getRollableResultsAsItemStacks());
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, SplashingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 12, 47);
        itemStacks.set(0, Arrays.asList(((Ingredient)recipe.func_192400_c().get(0)).func_193365_a()));
        NonNullList<ProcessingOutput> results = recipe.getRollableResults();
        boolean single = results.size() == 1;
        boolean excessive = results.size() > 9;
        for (int outputIndex = 0; outputIndex < results.size(); ++outputIndex) {
            int xOffset = outputIndex % 3 * 19;
            int yOffset = outputIndex / 3 * -19;
            itemStacks.init(outputIndex + 1, false, single ? 126 : 126 + xOffset, 47 + yOffset + (excessive ? 8 : 0));
            itemStacks.set(outputIndex + 1, ((ProcessingOutput)results.get(outputIndex)).getStack());
        }
        FanWashingCategory.addStochasticTooltip(itemStacks, results);
    }

    @Override
    protected void renderWidgets(MatrixStack matrixStack, SplashingRecipe recipe, double mouseX, double mouseY) {
        int size = recipe.getRollableResultsAsItemStacks().size();
        AllGuiTextures.JEI_SLOT.draw(matrixStack, 12, 47);
        AllGuiTextures.JEI_SHADOW.draw(matrixStack, 51, 29);
        AllGuiTextures.JEI_SHADOW.draw(matrixStack, 70, 39);
        AllGuiTextures.JEI_LONG_ARROW.draw(matrixStack, 42, 51);
        if (size == 1) {
            FanWashingCategory.getRenderedSlot(recipe, 0).draw(matrixStack, 126, 47);
            return;
        }
        for (int i = 0; i < size; ++i) {
            int xOffset = i % 3 * 19;
            int yOffset = i / 3 * -19 + (size > 9 ? 8 : 0);
            FanWashingCategory.getRenderedSlot(recipe, i).draw(matrixStack, 126 + xOffset, 47 + yOffset);
        }
    }

    @Override
    protected void translateFan(MatrixStack ms) {
        ms.func_227861_a_(60.0, 33.0, 0.0);
    }

    @Override
    public void renderAttachedBlock(MatrixStack matrixStack) {
        matrixStack.func_227860_a_();
        GuiGameElement.of((Fluid)Fluids.field_204546_a).scale(24.0).atLocal(0.0, 0.0, 2.0).render(matrixStack);
        matrixStack.func_227865_b_();
    }
}

