/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.content.palettes.PaletteBlockPattern;
import com.simibubi.create.content.palettes.PaletteStoneVariants;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.block.render.SpriteShifter;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.WoodType;
import net.minecraft.item.DyeColor;

public class AllSpriteShifts {
    static final Map<WoodType, CTSpriteShiftEntry> WOODEN_WINDOWS = new IdentityHashMap<WoodType, CTSpriteShiftEntry>();
    static final Map<PaletteStoneVariants, Map<PaletteBlockPattern.CTs, CTSpriteShiftEntry>> PALETTE_VARIANT_PATTERNS = new IdentityHashMap<PaletteStoneVariants, Map<PaletteBlockPattern.CTs, CTSpriteShiftEntry>>();
    public static final Map<DyeColor, SpriteShiftEntry> DYED_BELTS = new IdentityHashMap<DyeColor, SpriteShiftEntry>();
    public static final Map<DyeColor, SpriteShiftEntry> DYED_OFFSET_BELTS = new IdentityHashMap<DyeColor, SpriteShiftEntry>();
    public static final Map<DyeColor, SpriteShiftEntry> DYED_DIAGONAL_BELTS = new IdentityHashMap<DyeColor, SpriteShiftEntry>();
    public static final CTSpriteShiftEntry FRAMED_GLASS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "palettes/framed_glass", "palettes/framed_glass");
    public static final CTSpriteShiftEntry HORIZONTAL_FRAMED_GLASS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.HORIZONTAL, "palettes/framed_glass", "palettes/horizontal_framed_glass");
    public static final CTSpriteShiftEntry VERTICAL_FRAMED_GLASS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.VERTICAL, "palettes/framed_glass", "palettes/vertical_framed_glass");
    public static final CTSpriteShiftEntry ORNATE_IRON_WINDOW = AllSpriteShifts.vertical("palettes/ornate_iron_window");
    public static final CTSpriteShiftEntry CRAFTER_FRONT = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "crafter_top", "brass_casing");
    public static final CTSpriteShiftEntry CRAFTER_SIDE = CTSpriteShifter.getCT(CTSpriteShifter.CTType.VERTICAL, "crafter_side");
    public static final CTSpriteShiftEntry CRAFTER_OTHERSIDE = CTSpriteShifter.getCT(CTSpriteShifter.CTType.HORIZONTAL, "crafter_side");
    public static final CTSpriteShiftEntry ANDESITE_CASING = AllSpriteShifts.omni("andesite_casing");
    public static final CTSpriteShiftEntry BRASS_CASING = AllSpriteShifts.omni("brass_casing");
    public static final CTSpriteShiftEntry COPPER_CASING = AllSpriteShifts.omni("copper_casing");
    public static final CTSpriteShiftEntry SHADOW_STEEL_CASING = AllSpriteShifts.omni("shadow_steel_casing");
    public static final CTSpriteShiftEntry REFINED_RADIANCE_CASING = AllSpriteShifts.omni("refined_radiance_casing");
    public static final CTSpriteShiftEntry CREATIVE_CASING = CTSpriteShifter.getCT(CTSpriteShifter.CTType.CROSS, "creative_casing");
    public static final CTSpriteShiftEntry CHASSIS_SIDE = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "linear_chassis_side");
    public static final CTSpriteShiftEntry SECONDARY_CHASSIS_SIDE = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "secondary_linear_chassis_side");
    public static final CTSpriteShiftEntry CHASSIS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "linear_chassis_end");
    public static final CTSpriteShiftEntry CHASSIS_STICKY = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "linear_chassis_end_sticky");
    public static final CTSpriteShiftEntry BRASS_TUNNEL_TOP = AllSpriteShifts.vertical("brass_tunnel_top");
    public static final CTSpriteShiftEntry FLUID_TANK = CTSpriteShifter.getCT(CTSpriteShifter.CTType.CROSS, "fluid_tank");
    public static final CTSpriteShiftEntry CREATIVE_FLUID_TANK = CTSpriteShifter.getCT(CTSpriteShifter.CTType.CROSS, "creative_fluid_tank");
    public static final SpriteShiftEntry BELT = SpriteShifter.get("block/belt", "block/belt_scroll");
    public static final SpriteShiftEntry BELT_OFFSET = SpriteShifter.get("block/belt_offset", "block/belt_scroll");
    public static final SpriteShiftEntry BELT_DIAGONAL = SpriteShifter.get("block/belt_diagonal", "block/belt_diagonal_scroll");
    public static final SpriteShiftEntry ANDESIDE_BELT_CASING = SpriteShifter.get("block/brass_casing_belt", "block/andesite_casing_belt");
    public static final SpriteShiftEntry CRAFTER_THINGIES = SpriteShifter.get("block/crafter_thingies", "block/crafter_thingies");

    public static CTSpriteShiftEntry getWoodenWindow(WoodType woodType) {
        return WOODEN_WINDOWS.get(woodType);
    }

    public static CTSpriteShiftEntry getVariantPattern(PaletteStoneVariants variant, PaletteBlockPattern.CTs texture) {
        return PALETTE_VARIANT_PATTERNS.get((Object)variant).get((Object)texture);
    }

    private static void populateMaps() {
        WoodType[] supportedWoodTypes = new WoodType[]{WoodType.field_227038_a_, WoodType.field_227039_b_, WoodType.field_227040_c_, WoodType.field_227041_d_, WoodType.field_227042_e_, WoodType.field_227043_f_, WoodType.field_235923_g_, WoodType.field_235924_h_};
        Arrays.stream(supportedWoodTypes).forEach(woodType -> WOODEN_WINDOWS.put((WoodType)woodType, AllSpriteShifts.vertical("palettes/" + woodType.func_227048_b_() + "_window")));
        for (PaletteStoneVariants paletteStoneVariants : PaletteStoneVariants.values()) {
            String variantName = Lang.asId(paletteStoneVariants.name());
            IdentityHashMap<PaletteBlockPattern.CTs, CTSpriteShiftEntry> map = new IdentityHashMap<PaletteBlockPattern.CTs, CTSpriteShiftEntry>();
            PALETTE_VARIANT_PATTERNS.put(paletteStoneVariants, map);
            for (PaletteBlockPattern.CTs texture : PaletteBlockPattern.CTs.values()) {
                String textureName = Lang.asId(texture.name());
                String target = "palettes/" + variantName + "/" + textureName;
                map.put(texture, CTSpriteShifter.getCT(texture.type, target));
            }
        }
        for (PaletteStoneVariants paletteStoneVariants : DyeColor.values()) {
            String id = paletteStoneVariants.func_176610_l();
            DYED_BELTS.put((DyeColor)paletteStoneVariants, SpriteShifter.get("block/belt", "block/belt/" + id + "_scroll"));
            DYED_OFFSET_BELTS.put((DyeColor)paletteStoneVariants, SpriteShifter.get("block/belt_offset", "block/belt/" + id + "_scroll"));
            DYED_DIAGONAL_BELTS.put((DyeColor)paletteStoneVariants, SpriteShifter.get("block/belt_diagonal", "block/belt/" + id + "_diagonal_scroll"));
        }
    }

    static CTSpriteShiftEntry omni(String name) {
        return CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, name);
    }

    static CTSpriteShiftEntry vertical(String name) {
        return CTSpriteShifter.getCT(CTSpriteShifter.CTType.VERTICAL, name);
    }

    static CTSpriteShiftEntry horizontal(String name) {
        return CTSpriteShifter.getCT(CTSpriteShifter.CTType.HORIZONTAL, name);
    }

    static {
        AllSpriteShifts.populateMaps();
    }
}

