/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.actors.BellMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.CampfireMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.DispenserMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.DropperMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.repack.registrate.util.nullness.NonNullConsumer;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;

public class AllMovementBehaviours {
    private static final HashMap<ResourceLocation, MovementBehaviour> MOVEMENT_BEHAVIOURS = new HashMap();

    public static void addMovementBehaviour(ResourceLocation resourceLocation, MovementBehaviour movementBehaviour) {
        if (MOVEMENT_BEHAVIOURS.containsKey(resourceLocation)) {
            Create.LOGGER.warn("Movement behaviour for " + resourceLocation.toString() + " was overridden");
        }
        MOVEMENT_BEHAVIOURS.put(resourceLocation, movementBehaviour);
    }

    public static void addMovementBehaviour(Block block, MovementBehaviour movementBehaviour) {
        AllMovementBehaviours.addMovementBehaviour(block.getRegistryName(), movementBehaviour);
    }

    @Nullable
    public static MovementBehaviour of(ResourceLocation resourceLocation) {
        return MOVEMENT_BEHAVIOURS.getOrDefault(resourceLocation, null);
    }

    @Nullable
    public static MovementBehaviour of(Block block) {
        return AllMovementBehaviours.of(block.getRegistryName());
    }

    @Nullable
    public static MovementBehaviour of(BlockState state) {
        return AllMovementBehaviours.of(state.func_177230_c());
    }

    public static boolean contains(Block block) {
        return MOVEMENT_BEHAVIOURS.containsKey(block.getRegistryName());
    }

    public static <B extends Block> NonNullConsumer<? super B> addMovementBehaviour(MovementBehaviour movementBehaviour) {
        return b -> AllMovementBehaviours.addMovementBehaviour(b.getRegistryName(), movementBehaviour);
    }

    static void register() {
        AllMovementBehaviours.addMovementBehaviour(Blocks.field_222431_lT, (MovementBehaviour)new BellMovementBehaviour());
        AllMovementBehaviours.addMovementBehaviour(Blocks.field_222433_lV, (MovementBehaviour)new CampfireMovementBehaviour());
        DispenserMovementBehaviour.gatherMovedDispenseItemBehaviours();
        AllMovementBehaviours.addMovementBehaviour(Blocks.field_150367_z, (MovementBehaviour)new DispenserMovementBehaviour());
        AllMovementBehaviours.addMovementBehaviour(Blocks.field_150409_cd, (MovementBehaviour)new DropperMovementBehaviour());
    }
}

