/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.data;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.psi.api.recipe.TrickRecipeBuilder;
import vazkii.psi.common.Psi;
import vazkii.psi.common.crafting.recipe.DimensionTrickRecipe;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.lib.LibResources;

public class TrickRecipeGenerator
extends RecipeProvider {
    public TrickRecipeGenerator(DataGenerator generator) {
        super(generator);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        TrickRecipeBuilder.of((IItemProvider)ModItems.psidust).input((ITag.INamedTag<Item>)Tags.Items.DUSTS_REDSTONE).cad((IItemProvider)ModItems.cadAssemblyIron).build(consumer);
        TrickRecipeBuilder.of(PatchouliAPI.instance.getBookStack(LibResources.PATCHOULI_BOOK)).input(new IItemProvider[]{Items.field_151122_aG}).cad((IItemProvider)ModItems.cadAssemblyIron).build(consumer);
        TrickRecipeBuilder.of((IItemProvider)ModItems.cadAssemblyPsimetal).input(new IItemProvider[]{ModItems.cadAssemblyGold}).trick(Psi.location("trick_infusion")).cad((IItemProvider)ModItems.cadAssemblyIron).build(consumer, Psi.location("gold_to_psimetal_assembly_upgrade"));
        TrickRecipeBuilder.of((IItemProvider)ModItems.psimetal).input((ITag.INamedTag<Item>)Tags.Items.INGOTS_GOLD).trick(Psi.location("trick_infusion")).cad((IItemProvider)ModItems.cadAssemblyIron).build(consumer);
        TrickRecipeBuilder.of((IItemProvider)ModItems.psigem).input((ITag.INamedTag<Item>)Tags.Items.GEMS_DIAMOND).trick(Psi.location("trick_greater_infusion")).cad((IItemProvider)ModItems.cadAssemblyPsimetal).build(consumer);
        TrickRecipeBuilder builder = TrickRecipeBuilder.of((IItemProvider)ModItems.ebonySubstance).input((ITag.INamedTag<Item>)ItemTags.field_219775_L).trick(Psi.location("trick_ebony_ivory")).cad((IItemProvider)ModItems.cadAssemblyPsimetal);
        TrickRecipeGenerator.dimension(builder, consumer, ModItems.ebonySubstance.getRegistryName(), (RegistryKey<World>)World.field_234920_i_);
        builder = TrickRecipeBuilder.of((IItemProvider)ModItems.ivorySubstance).input((ITag.INamedTag<Item>)Tags.Items.GEMS_QUARTZ).trick(Psi.location("trick_ebony_ivory")).cad((IItemProvider)ModItems.cadAssemblyPsimetal);
        TrickRecipeGenerator.dimension(builder, consumer, ModItems.ivorySubstance.getRegistryName(), (RegistryKey<World>)World.field_234920_i_);
    }

    @Nonnull
    public String func_200397_b() {
        return "Psi trick crafting recipes";
    }

    public static void dimension(TrickRecipeBuilder builder, Consumer<IFinishedRecipe> parent, ResourceLocation id, RegistryKey<World> dimensionKey) {
        parent.accept(new DimensionResult(id, builder, dimensionKey));
    }

    public static class DimensionResult
    extends TrickRecipeBuilder.Result {
        private final RegistryKey<World> dimensionId;

        protected DimensionResult(ResourceLocation id, TrickRecipeBuilder builder, RegistryKey<World> type) {
            super(id, builder);
            this.dimensionId = type;
        }

        @Override
        public void func_218610_a(@Nonnull JsonObject json) {
            super.func_218610_a(json);
            json.addProperty("dimension", this.dimensionId.func_240901_a_().toString());
        }

        @Override
        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return DimensionTrickRecipe.SERIALIZER;
        }
    }
}

