/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class MessageDeductPsi {
    private final int prev;
    private final int current;
    private final int cd;
    private final boolean shatter;

    public MessageDeductPsi(int prev, int current, int cd, boolean shatter) {
        this.prev = prev;
        this.current = current;
        this.cd = cd;
        this.shatter = shatter;
    }

    public MessageDeductPsi(PacketBuffer buf) {
        this.prev = buf.func_150792_a();
        this.current = buf.func_150792_a();
        this.cd = buf.func_150792_a();
        this.shatter = buf.readBoolean();
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.prev);
        buf.func_150787_b(this.current);
        buf.func_150787_b(this.cd);
        buf.writeBoolean(this.shatter);
    }

    public boolean receive(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            PlayerEntity player = Psi.proxy.getClientPlayer();
            if (player != null) {
                PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
                data.lastAvailablePsi = data.availablePsi;
                data.availablePsi = this.current;
                data.regenCooldown = this.cd;
                data.deductTick = true;
                data.addDeduction(this.prev, this.prev - this.current, this.shatter);
            }
        });
        return true;
    }
}

