/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.item.ItemSpellDrive;

public class DriveDuplicateRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<DriveDuplicateRecipe> SERIALIZER = new SpecialRecipeSerializer(DriveDuplicateRecipe::new);

    public DriveDuplicateRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean foundSource = false;
        boolean foundTarget = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemSpellDrive) {
                if (ItemSpellDrive.getSpell(stack) == null) {
                    if (foundTarget) {
                        return false;
                    }
                    foundTarget = true;
                    continue;
                }
                if (foundSource) {
                    return false;
                }
                foundSource = true;
                continue;
            }
            return false;
        }
        return foundSource && foundTarget;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        Spell source = null;
        ItemStack target = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Spell spell = ItemSpellDrive.getSpell(stack);
            if (spell != null) {
                source = spell;
                continue;
            }
            target = stack;
        }
        ItemStack copy = target.func_77946_l();
        ItemSpellDrive.setSpell(copy, source);
        return copy;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item.func_190926_b() || ItemSpellDrive.getSpell(item) == null) continue;
            list.set(i, (Object)item.func_77946_l());
            break;
        }
        return list;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public boolean func_192399_d() {
        return true;
    }
}

