/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.gui.PsiHudElementType;
import vazkii.psi.api.gui.RenderPsiHudEvent;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.client.core.handler.ShaderHandler;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.base.IHUDItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="psi")
public final class HUDHandler {
    private static final ResourceLocation psiBar = new ResourceLocation("psi:textures/gui/psi_bar.png");
    private static final ResourceLocation psiBarMask = new ResourceLocation("psi:textures/gui/psi_bar_mask.png");
    private static final ResourceLocation psiBarShatter = new ResourceLocation("psi:textures/gui/psi_bar_shatter.png");
    private static final int secondaryTextureUnit = 7;
    private static boolean registeredMask = false;
    private static final int maxRemainingTicks = 30;
    private static ItemStack remainingDisplayStack;
    private static int remainingTime;
    private static int remainingCount;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onDraw(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            MainWindow resolution = event.getWindow();
            float partialTicks = event.getPartialTicks();
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.PSI_BAR))) {
                HUDHandler.drawPsiBar(event.getMatrixStack(), resolution, partialTicks);
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.SOCKETABLE_EQUIPPED_NAME))) {
                HUDHandler.renderSocketableEquippedName(event.getMatrixStack(), resolution, partialTicks);
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.REMAINING_ITEMS))) {
                HUDHandler.renderRemainingItems(event.getMatrixStack(), resolution, partialTicks);
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.HUD_ITEM))) {
                HUDHandler.renderHUDItem(event.getMatrixStack(), resolution, partialTicks);
            }
        }
    }

    public static void tick() {
        if (remainingTime > 0) {
            --remainingTime;
        }
    }

    private static boolean showsBar(PlayerDataHandler.PlayerData data, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.getCapability(PsiAPI.PSI_BAR_DISPLAY_CAPABILITY).map(c -> c.shouldShow(data)).orElse(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawPsiBar(MatrixStack ms, MainWindow res, float pticks) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack cadStack = PsiAPI.getPlayerCAD((PlayerEntity)mc.field_71439_g);
        if (cadStack.func_190926_b()) {
            return;
        }
        ICAD cad = (ICAD)cadStack.func_77973_b();
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((PlayerEntity)mc.field_71439_g);
        int totalPsi = data.getTotalPsi();
        int currPsi = data.getAvailablePsi();
        if (((Boolean)ConfigHandler.CLIENT.contextSensitiveBar.get()).booleanValue() && currPsi == totalPsi && !HUDHandler.showsBar(data, mc.field_71439_g.func_184614_ca()) && !HUDHandler.showsBar(data, mc.field_71439_g.func_184592_cb())) {
            return;
        }
        ms.func_227860_a_();
        boolean right = (Boolean)ConfigHandler.CLIENT.psiBarOnRight.get();
        int pad = 3;
        int width = 32;
        int height = 140;
        int x = -pad;
        if (right) {
            x = res.func_198107_o() + pad - width;
        }
        int y = res.func_198087_p() / 2 - height / 2;
        if (!registeredMask) {
            mc.field_71446_o.func_110577_a(psiBarMask);
            mc.field_71446_o.func_110577_a(psiBarShatter);
            registeredMask = true;
        }
        RenderSystem.enableBlend();
        mc.field_71446_o.func_110577_a(psiBar);
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)64, (int)256);
        x += 8;
        y += 26;
        width = 16;
        height = 106;
        float r = 0.6f;
        float g = 0.65f;
        float b = 1.0f;
        int origHeight = height;
        int origY = y;
        int v = 0;
        int texture = 0;
        boolean shaders = ShaderHandler.useShaders;
        if (shaders) {
            RenderSystem.activeTexture((int)33991);
            texture = GL11.glGetInteger((int)32873);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        for (PlayerDataHandler.PlayerData.Deduction d : data.deductions) {
            float a = d.getPercentile(pticks);
            RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
            height = (int)Math.ceil((double)origHeight * (double)d.deduct / (double)totalPsi);
            int effHeight = (int)((double)origHeight * (double)d.current / (double)totalPsi);
            v = origHeight - effHeight;
            y = origY + v;
            ShaderHandler.useShader(ShaderHandler.psiBar, HUDHandler.generateCallback(a, d.shatter, data.overflowed));
            AbstractGui.func_238463_a_((MatrixStack)ms, (int)x, (int)y, (float)32.0f, (float)v, (int)width, (int)height, (int)64, (int)256);
        }
        float textY = origY;
        if (totalPsi > 0) {
            height = (int)((double)origHeight * (double)data.availablePsi / (double)totalPsi);
            v = origHeight - height;
            y = origY + v;
            if (data.availablePsi != data.lastAvailablePsi) {
                float textHeight = (float)((double)origHeight * ((double)((float)data.availablePsi * pticks) + (double)data.lastAvailablePsi * (1.0 - (double)pticks)) / (double)totalPsi);
                textY = (float)origY + ((float)origHeight - textHeight);
            } else {
                textY = y;
            }
        } else {
            height = 0;
        }
        RenderSystem.color3f((float)r, (float)g, (float)b);
        ShaderHandler.useShader(ShaderHandler.psiBar, HUDHandler.generateCallback(1.0f, false, data.overflowed));
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)x, (int)y, (float)32.0f, (float)v, (int)width, (int)height, (int)64, (int)256);
        ShaderHandler.releaseShader();
        if (shaders) {
            RenderSystem.activeTexture((int)33991);
            RenderSystem.bindTexture((int)texture);
            RenderSystem.activeTexture((int)33984);
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, (double)textY, 0.0);
        width = 44;
        height = 3;
        int storedPsi = cad.getStoredPsi(cadStack);
        String s1 = storedPsi == -1 ? "\u221e" : "" + data.availablePsi;
        String s2 = "" + storedPsi;
        int offBar = 22;
        int offStr1 = 7 + mc.field_71466_p.func_78256_a(s1);
        int offStr2 = 7 + mc.field_71466_p.func_78256_a(s2);
        if (!right) {
            offBar = 6;
            offStr1 = -23;
            offStr2 = -23;
        }
        int color = cad.getSpellColor(cadStack);
        RenderSystem.color4f((float)((float)PsiRenderHelper.r(color) / 255.0f), (float)((float)PsiRenderHelper.g(color) / 255.0f), (float)((float)PsiRenderHelper.b(color) / 255.0f), (float)1.0f);
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)(x - offBar), (int)-2, (float)0.0f, (float)140.0f, (int)width, (int)height, (int)64, (int)256);
        mc.field_71466_p.func_238405_a_(ms, s1, (float)(x - offStr1), -11.0f, 0xFFFFFF);
        ms.func_227865_b_();
        if (storedPsi != -1) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, (double)Math.max(textY + 3.0f, (float)(origY + 100)), 0.0);
            mc.field_71466_p.func_238405_a_(ms, s2, (float)(x - offStr2), 0.0f, 0xFFFFFF);
            ms.func_227865_b_();
        }
        RenderSystem.disableBlend();
        ms.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderSocketableEquippedName(MatrixStack ms, MainWindow res, float pticks) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = mc.field_71439_g.func_184586_b(Hand.MAIN_HAND);
        if (!ISocketable.isSocketable(stack)) {
            return;
        }
        String name = ISocketable.getSocketedItemName(stack, "").getString();
        if (stack.func_190926_b() || name.trim().isEmpty()) {
            return;
        }
        int ticks = mc.field_71456_v.field_92017_k;
        if ((ticks -= 10) > 0) {
            ISocketable socketable = ISocketable.socketable(stack);
            ItemStack bullet = socketable.getSelectedBullet();
            int alpha = Math.min(255, (int)(((float)ticks - pticks) * 256.0f / 10.0f));
            int color = 1295871 + (alpha << 24);
            int x = res.func_198107_o() / 2 - mc.field_71466_p.func_78256_a(name) / 2;
            int y = res.func_198087_p() - 71;
            if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                y += 14;
            }
            mc.field_71466_p.func_238405_a_(ms, name, (float)x, (float)y, color);
            int w = mc.field_71466_p.func_78256_a(name);
            ms.func_227860_a_();
            ms.func_227861_a_((double)(x + w), (double)(y - 6), 0.0);
            ms.func_227862_a_((float)alpha / 255.0f, 1.0f, 1.0f);
            PsiRenderHelper.transferMsToGl(ms, () -> mc.func_175599_af().func_175042_a(bullet, 0, 0));
            ms.func_227865_b_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderRemainingItems(MatrixStack ms, MainWindow resolution, float partTicks) {
        if (remainingTime > 0 && !remainingDisplayStack.func_190926_b()) {
            int pos = 30 - remainingTime;
            Minecraft mc = Minecraft.func_71410_x();
            int remainingLeaveTicks = 20;
            int x = resolution.func_198107_o() / 2 + 10 + Math.max(0, pos - remainingLeaveTicks);
            int y = resolution.func_198087_p() / 2;
            int start = 30 - remainingLeaveTicks;
            float alpha = (float)remainingTime + partTicks > (float)start ? 1.0f : ((float)remainingTime + partTicks) / (float)start;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            int xp = x + (int)(16.0f * (1.0f - alpha));
            ms.func_227860_a_();
            ms.func_227861_a_((double)xp, (double)y, 0.0);
            ms.func_227862_a_(alpha, 1.0f, 1.0f);
            PsiRenderHelper.transferMsToGl(ms, () -> mc.func_175599_af().func_180450_b(remainingDisplayStack, 0, 0));
            ms.func_227862_a_(1.0f / alpha, 1.0f, 1.0f);
            ms.func_227861_a_((double)(-xp), (double)(-y), 0.0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String text = remainingDisplayStack.func_200301_q().func_230531_f_().func_240699_a_(TextFormatting.GREEN).getString();
            if (remainingCount >= 0) {
                int max = remainingDisplayStack.func_77976_d();
                int stacks = remainingCount / max;
                int rem = remainingCount % max;
                text = stacks == 0 ? "" + remainingCount : remainingCount + " (" + TextFormatting.AQUA + stacks + TextFormatting.RESET + "*" + TextFormatting.GRAY + max + TextFormatting.RESET + "+" + TextFormatting.YELLOW + rem + TextFormatting.RESET + ")";
            } else if (remainingCount == -1) {
                text = "\u221e";
            }
            int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            mc.field_71466_p.func_238405_a_(ms, text, (float)(x + 20), (float)(y + 6), color);
            ms.func_227865_b_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderHUDItem(MatrixStack ms, MainWindow resolution, float partTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IHUDItem) {
            ((IHUDItem)stack.func_77973_b()).drawHUD(ms, resolution, partTicks, stack);
        }
        if (!(stack = mc.field_71439_g.func_184592_cb()).func_190926_b() && stack.func_77973_b() instanceof IHUDItem) {
            ((IHUDItem)stack.func_77973_b()).drawHUD(ms, resolution, partTicks, stack);
        }
    }

    public static void setRemaining(ItemStack stack, int count) {
        remainingDisplayStack = stack;
        remainingCount = count;
        remainingTime = stack.func_190926_b() ? 0 : 30;
    }

    public static void setRemaining(PlayerEntity player, ItemStack displayStack, Pattern pattern) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(pattern == null ? ItemStack.func_179545_c((ItemStack)displayStack, (ItemStack)stack) : pattern.matcher(stack.func_77977_a()).find())) continue;
            count += stack.func_190916_E();
        }
        HUDHandler.setRemaining(displayStack, count);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Consumer<Integer> generateCallback(float percentile, boolean shatter, boolean overflowed) {
        Minecraft mc = Minecraft.func_71410_x();
        return shader -> {
            int percentileUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"percentile");
            int overflowedUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"overflowed");
            int imageUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"image");
            int maskUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"mask");
            RenderSystem.activeTexture((int)33984);
            mc.field_71446_o.func_110577_a(psiBar);
            ARBShaderObjects.glUniform1iARB((int)imageUniform, (int)0);
            RenderSystem.activeTexture((int)33991);
            RenderSystem.enableTexture();
            mc.field_71446_o.func_110577_a(shatter ? psiBarShatter : psiBarMask);
            ARBShaderObjects.glUniform1iARB((int)maskUniform, (int)7);
            ARBShaderObjects.glUniform1fARB((int)percentileUniform, (float)percentile);
            ARBShaderObjects.glUniform1iARB((int)overflowedUniform, (int)(overflowed ? 1 : 0));
        };
    }
}

