/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.auto_restart.util;

import de.geheimagentnr1.auto_restart.config.ServerConfig;
import de.geheimagentnr1.auto_restart.util.StopType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerRestarter {
    private static final Logger LOGGER = LogManager.getLogger(ServerRestarter.class);
    private static volatile boolean shouldDoRestart = false;

    public static void restart(MinecraftServer server) {
        shouldDoRestart = true;
        ServerRestarter.createRestartFile();
        server.func_71263_m(false);
    }

    public static void restartServer() {
        if (!ServerConfig.usesExternalRestartScript()) {
            LOGGER.info("Restart Server");
            ProcessBuilder builder = new ProcessBuilder(ServerConfig.getRestartCommand());
            try {
                builder.start();
            }
            catch (IOException exception) {
                LOGGER.error("Auto Restart could not be done.", (Throwable)exception);
            }
        }
    }

    public static void createExceptionFile() {
        ServerRestarter.saveToFile(StopType.EXCEPTION);
    }

    public static void createStopFile() {
        ServerRestarter.saveToFile(StopType.STOP);
    }

    private static void createRestartFile() {
        ServerRestarter.saveToFile(StopType.RESTART);
    }

    private static void saveToFile(StopType type) {
        OutputStreamWriter fileWriter = null;
        try {
            LOGGER.info("Saving restart status \"{}\" to file", (Object)type);
            File file = new File("." + File.separator + "auto_restart" + File.separator + "restart");
            if (file.exists() || file.getParentFile().mkdirs() && file.createNewFile()) {
                fileWriter = new FileWriter(file);
                fileWriter.write(String.valueOf(type.ordinal() - 1));
                fileWriter.flush();
            } else {
                LOGGER.error("Restart File could not be created");
            }
        }
        catch (IOException exception) {
            LOGGER.error("FileWriter failed", (Throwable)exception);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException exception) {
                    LOGGER.error("FileWriter failed to close", (Throwable)exception);
                }
            }
        }
    }

    public static boolean shouldDoRestart() {
        return shouldDoRestart;
    }
}

