/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.auto_restart.config;

import de.geheimagentnr1.auto_restart.config.TimeUnit;
import java.util.Optional;

public class Timing {
    private final long value;
    private final TimeUnit timeUnit;

    private Timing(long _value, TimeUnit _timeUnit) {
        this.value = _value;
        this.timeUnit = _timeUnit;
    }

    static Timing build(long value, TimeUnit timeUnit) {
        return new Timing(value, timeUnit);
    }

    static Optional<Timing> parse(String timingString) {
        String valueString = timingString.substring(0, timingString.length() - 1);
        String timeUnitString = timingString.substring(timingString.length() - 1);
        try {
            long value = Long.parseLong(valueString);
            Optional<TimeUnit> timeUnit = TimeUnit.parse(timeUnitString);
            if (value < 0L) {
                return Optional.empty();
            }
            return timeUnit.map(unit -> new Timing(value, (TimeUnit)((Object)unit)));
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    public long getSeconds() {
        switch (this.timeUnit) {
            case SECONDS: {
                return this.value;
            }
            case MINUTES: {
                return this.value * 60L;
            }
            case HOURS: {
                return this.value * 3600L;
            }
        }
        return 0L;
    }

    public String getDisplayString() {
        return String.format("%d %s", this.value, this.timeUnit.getText(this.value));
    }

    public String toString() {
        return this.value + this.timeUnit.getSign();
    }
}

