/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.auto_restart.config;

import de.geheimagentnr1.auto_restart.config.AutoRestartTime;
import de.geheimagentnr1.auto_restart.config.TimeUnit;
import de.geheimagentnr1.auto_restart.config.Timing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerConfig {
    private static final Logger LOGGER = LogManager.getLogger(ServerConfig.class);
    private static final String MOD_NAME = ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName();
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    private static final ForgeConfigSpec.BooleanValue USES_EXTERNAL_RESTART_SCRIPT;
    private static final ForgeConfigSpec.ConfigValue<String> RESTART_COMMAND;
    private static final ForgeConfigSpec.BooleanValue AUTO_RESTART_ENABLED;
    private static final ForgeConfigSpec.ConfigValue<List<String>> AUTO_RESTART_TIMES;
    private static final ForgeConfigSpec.BooleanValue AUTO_RESTART_ON_CRASH;
    private static final ForgeConfigSpec.ConfigValue<List<String>> AUTO_RESTART_WARNING_TIMES;
    private static final ForgeConfigSpec.BooleanValue ON_EMPTY_RESTART_ENABLED;
    private static final ForgeConfigSpec.ConfigValue<String> ON_EMPTY_RESTART_DELAY;
    private static final ForgeConfigSpec.BooleanValue LOW_TPS_RESTART_ENABLED;
    private static final ForgeConfigSpec.DoubleValue LOW_TPS_RESTART_MINIMUM_TPS_LEVEL;
    private static final ForgeConfigSpec.ConfigValue<String> LOW_TPS_RESTART_DELAY;
    private static final ArrayList<AutoRestartTime> autoRestartTimes;
    private static final ArrayList<Timing> autoRestartWarningTimes;
    private static Timing onEmptyRestartDelay;
    private static Timing lowTpsRestartDelay;

    public static void handleConfigChange() {
        ServerConfig.printConfig();
        ServerConfig.loadAutoRestartTimes();
        ServerConfig.loadAutoRestartWarningTimes();
        ServerConfig.loadOnEmptyRestartDelay();
        ServerConfig.loadLowTpsRestartDelay();
    }

    private static void printConfig() {
        LOGGER.info("Loading \"{}\" Server Config", (Object)MOD_NAME);
        LOGGER.info("{} = {}", (Object)USES_EXTERNAL_RESTART_SCRIPT.getPath(), USES_EXTERNAL_RESTART_SCRIPT.get());
        LOGGER.info("{} = {}", (Object)RESTART_COMMAND.getPath(), RESTART_COMMAND.get());
        LOGGER.info("{} = {}", (Object)AUTO_RESTART_ENABLED.getPath(), AUTO_RESTART_ENABLED.get());
        LOGGER.info("{} = {}", (Object)AUTO_RESTART_TIMES.getPath(), AUTO_RESTART_TIMES.get());
        LOGGER.info("{} = {}", (Object)AUTO_RESTART_ON_CRASH.getPath(), AUTO_RESTART_ON_CRASH.get());
        LOGGER.info("{} = {}", (Object)AUTO_RESTART_WARNING_TIMES.getPath(), AUTO_RESTART_WARNING_TIMES.get());
        LOGGER.info("{} = {}", (Object)ON_EMPTY_RESTART_ENABLED.getPath(), ON_EMPTY_RESTART_ENABLED.get());
        LOGGER.info("{} = {}", (Object)ON_EMPTY_RESTART_DELAY.getPath(), ON_EMPTY_RESTART_DELAY.get());
        LOGGER.info("\"{}\" Server Config loaded", (Object)MOD_NAME);
    }

    private static synchronized void loadAutoRestartTimes() {
        autoRestartTimes.clear();
        List autoRestartTimeStrings = (List)AUTO_RESTART_TIMES.get();
        for (int i = 0; i < autoRestartTimeStrings.size(); ++i) {
            Optional<AutoRestartTime> autoRestartTime = AutoRestartTime.parse((String)autoRestartTimeStrings.get(i));
            if (autoRestartTime.isPresent()) {
                autoRestartTimes.add(autoRestartTime.get());
                continue;
            }
            LOGGER.warn("{}: Removed invalid {} from auto restart times.", (Object)MOD_NAME, autoRestartTimeStrings.get(i));
            autoRestartTimeStrings.remove(i);
            --i;
        }
    }

    private static synchronized void loadAutoRestartWarningTimes() {
        autoRestartWarningTimes.clear();
        List autoRestartWarningTimeStrings = (List)AUTO_RESTART_WARNING_TIMES.get();
        for (int i = 0; i < autoRestartWarningTimeStrings.size(); ++i) {
            Optional<Timing> autoRestartWarningTime = Timing.parse((String)autoRestartWarningTimeStrings.get(i));
            if (autoRestartWarningTime.isPresent()) {
                autoRestartWarningTimes.add(autoRestartWarningTime.get());
                continue;
            }
            LOGGER.warn(String.format("%s: Removed invalid %s from auto restart warning times.", MOD_NAME, autoRestartWarningTime));
            autoRestartWarningTimeStrings.remove(i);
            --i;
        }
    }

    private static void loadOnEmptyRestartDelay() {
        try {
            onEmptyRestartDelay = Timing.parse((String)ON_EMPTY_RESTART_DELAY.get()).orElseThrow(() -> new IllegalStateException(String.format("%s: Invalid on empty restart delay", MOD_NAME)));
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    private static void loadLowTpsRestartDelay() {
        try {
            lowTpsRestartDelay = Timing.parse((String)LOW_TPS_RESTART_DELAY.get()).orElseThrow(() -> new IllegalStateException(String.format("%s: Invalid low tps restart delay", MOD_NAME)));
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    public static boolean usesExternalRestartScript() {
        return (Boolean)USES_EXTERNAL_RESTART_SCRIPT.get();
    }

    public static String getRestartCommand() {
        return (String)RESTART_COMMAND.get();
    }

    public static boolean isAutoRestartEnabled() {
        if (ServerConfig.getAutoRestartTimes().isEmpty()) {
            AUTO_RESTART_ENABLED.set((Object)false);
        }
        return (Boolean)AUTO_RESTART_ENABLED.get();
    }

    public static synchronized List<AutoRestartTime> getAutoRestartTimes() {
        return autoRestartTimes;
    }

    public static boolean shouldAutoRestartOnCrash() {
        return (Boolean)AUTO_RESTART_ON_CRASH.get();
    }

    public static synchronized List<Timing> getAutoRestartWarningTimes() {
        return autoRestartWarningTimes;
    }

    public static boolean getOnEmptyRestartEnabled() {
        return (Boolean)ON_EMPTY_RESTART_ENABLED.get();
    }

    public static Timing getOnEmptyRestartDelay() {
        return onEmptyRestartDelay;
    }

    public static boolean isLowTpsRestartEnabled() {
        return (Boolean)LOW_TPS_RESTART_ENABLED.get();
    }

    public static double getLowTpsRestartMinimumTpsLevel() {
        return (Double)LOW_TPS_RESTART_MINIMUM_TPS_LEVEL.get();
    }

    public static Timing getLowTpsRestartDelay() {
        return lowTpsRestartDelay;
    }

    static {
        autoRestartTimes = new ArrayList();
        autoRestartWarningTimes = new ArrayList();
        BUILDER.comment("Options for restarting:").push("restart");
        USES_EXTERNAL_RESTART_SCRIPT = BUILDER.comment("Is the server started by an external restart script?").define("use_external_restart_script", false);
        RESTART_COMMAND = BUILDER.comment(String.format("Command that is executed on Server stopped to restart the server. Only called if \"%s\" is false.", USES_EXTERNAL_RESTART_SCRIPT.getPath())).define("restart_command", (Object)"");
        BUILDER.pop();
        BUILDER.comment("Option for auto restarting:").push("auto_restart");
        AUTO_RESTART_ENABLED = BUILDER.comment("Should the Server do automatic restarts?").define("enabled", false);
        AUTO_RESTART_TIMES = BUILDER.comment("Times in 24-hour format on which the server will automatically restart").define("times", new ArrayList<String>(Arrays.asList(AutoRestartTime.build(14, 0).toString(), AutoRestartTime.build(16, 32).toString())));
        AUTO_RESTART_ON_CRASH = BUILDER.comment("Should the server be automatically restarted when it crashes.").define("on_crash", false);
        AUTO_RESTART_WARNING_TIMES = BUILDER.comment(new String[]{"Times before an auto restart of the server, a restart warning should be shown.", "Examples:", " - 5s - For a message 5 seconds before a restart", " - 7m - For a message 7 minutes before a restart", " - 2h - For a message 2 hours before a restart"}).define("warning_times", new ArrayList<String>(Arrays.asList(Timing.build(5L, TimeUnit.SECONDS).toString(), Timing.build(4L, TimeUnit.SECONDS).toString(), Timing.build(3L, TimeUnit.SECONDS).toString(), Timing.build(2L, TimeUnit.SECONDS).toString(), Timing.build(1L, TimeUnit.SECONDS).toString())));
        BUILDER.pop();
        BUILDER.comment("Options for restart, if the server is empty:").push("on_empty_restart");
        ON_EMPTY_RESTART_ENABLED = BUILDER.comment("Should the server restart, if no players are online?").define("enabled", false);
        ON_EMPTY_RESTART_DELAY = BUILDER.comment(new String[]{"Delay after the server should restart, if it is empty.", "Examples:", " - 5s - For a delay 5 seconds", " - 7m - For a delay 7 minutes", " - 2h - For a delay 2 hours"}).define("delay", (Object)Timing.build(10L, TimeUnit.MINUTES).toString(), object -> {
            if (object instanceof String) {
                return Timing.parse((String)object).isPresent();
            }
            return false;
        });
        BUILDER.pop();
        BUILDER.comment("Options for restart, if the tps of server or its dimensions are low:").push("low_tps_restart");
        LOW_TPS_RESTART_ENABLED = BUILDER.comment("Should the server restart, if it is below a tps level for a specified time?").define("enabled", false);
        LOW_TPS_RESTART_MINIMUM_TPS_LEVEL = BUILDER.comment("TPS level below which the server is restarted, if it lasts for a specified time.").defineInRange("minium_tps_level", 0.0, 0.0, 20.0);
        LOW_TPS_RESTART_DELAY = BUILDER.comment(new String[]{"Delay, that the server must be below the defined TPS level, in order for it to be restarted.", "Examples:", " - 5s - For a delay 5 seconds", " - 7m - For a delay 7 minutes", " - 2h - For a delay 2 hours"}).define("delay", (Object)Timing.build(1L, TimeUnit.MINUTES).toString(), object -> {
            if (object instanceof String) {
                return Timing.parse((String)object).isPresent();
            }
            return false;
        });
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

