/*
 * Decompiled with CFR 0.152.
 */
package com.zetal.playertrade.message;

import com.zetal.playertrade.PlayerTradePackets;
import com.zetal.playertrade.handler.TradeEventHandler;
import com.zetal.playertrade.inventory.ContainerTrade;
import com.zetal.playertrade.message.ProcessTradePacketClient;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class TradePacket {
    public final UUID p1;
    public final boolean ready1;
    public final boolean ready2;

    public TradePacket(UUID p1, boolean r1, boolean r2) {
        this.p1 = p1;
        this.ready1 = r1;
        this.ready2 = r2;
    }

    public static void encode(TradePacket pkt, PacketBuffer buf) {
        buf.func_180714_a(pkt.p1.toString());
        buf.writeBoolean(pkt.ready1);
        buf.writeBoolean(pkt.ready2);
    }

    public static TradePacket decode(PacketBuffer buf) {
        return new TradePacket(UUID.fromString(buf.func_150789_c(Short.MAX_VALUE)), buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(TradePacket pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        if (contextSupplier.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            TradePacket.handleServer(pkt, contextSupplier);
        } else {
            ProcessTradePacketClient.onMessageReceived(pkt, contextSupplier);
        }
    }

    public static void handleServer(TradePacket pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            UUID clientFrom = pkt.p1;
            boolean ready1 = pkt.ready1;
            MinecraftServer server = context.getSender().field_71133_b;
            if (server.func_184103_al().func_177451_a(clientFrom) instanceof PlayerEntity) {
                ServerPlayerEntity client = server.func_184103_al().func_177451_a(clientFrom);
                PlayerEntity target = TradeEventHandler.getTradePartner((PlayerEntity)client);
                if (client != null && target != null && client.field_71070_bA instanceof ContainerTrade && target.field_71070_bA instanceof ContainerTrade) {
                    ContainerTrade con1 = (ContainerTrade)client.field_71070_bA;
                    ContainerTrade con2 = (ContainerTrade)target.field_71070_bA;
                    if (TradeEventHandler.getTradePartner((PlayerEntity)client).func_110124_au().equals(target.func_110124_au()) && con1.theReady != ready1) {
                        con1.theReady = con1.canTradeFit() ? ready1 : false;
                        PlayerTradePackets.sendTo(new TradePacket(clientFrom, con1.theReady, con2.theReady), (PlayerEntity)client);
                        PlayerTradePackets.sendTo(new TradePacket(target.func_110124_au(), con2.theReady, con1.theReady), target);
                        if (con1.theReady && con2.theReady) {
                            TradePacket.completeTrade((PlayerEntity)client, target);
                        }
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static void completeTrade(PlayerEntity client, PlayerEntity target) {
        NonNullList<ItemStack> player2Trade;
        ContainerTrade con1 = (ContainerTrade)client.field_71070_bA;
        ContainerTrade con2 = (ContainerTrade)target.field_71070_bA;
        NonNullList<ItemStack> player1Trade = con1.tradeInventory.player1Trade;
        con1.tradeInventory.player1Trade = player2Trade = con2.tradeInventory.player1Trade;
        con1.tradeInventory.player2Trade = player1Trade;
        con2.tradeInventory.player1Trade = player1Trade;
        con2.tradeInventory.player2Trade = player2Trade;
        client.func_71053_j();
    }
}

