/*
 * Decompiled with CFR 0.152.
 */
package com.zetal.playertrade.message;

import com.zetal.playertrade.inventory.ContainerTrade;
import com.zetal.playertrade.message.TradePacket;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessTradePacketClient {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onMessageReceived(TradePacket message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.CLIENT) {
            LOGGER.warn("TradePacket received on wrong side:" + ctx.getDirection().getReceptionSide());
            return;
        }
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            LOGGER.warn("TradePacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ProcessTradePacketClient.processMessage((ClientWorld)clientWorld.get(), message));
    }

    private static void processMessage(ClientWorld worldClient, TradePacket pkt) {
        UUID theClient = pkt.p1;
        boolean theReady = pkt.ready1;
        boolean traderReady = pkt.ready2;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (theClient.equals(player.func_110124_au()) && player.field_71070_bA instanceof ContainerTrade) {
            ContainerTrade con = (ContainerTrade)player.field_71070_bA;
            if (con.theReady != theReady) {
                con.theReady = theReady;
            }
            if (con.traderReady != traderReady) {
                con.traderReady = traderReady;
            }
        }
    }
}

