/*
 * Decompiled with CFR 0.152.
 */
package com.zetal.playertrade.handler;

import com.zetal.playertrade.inventory.ContainerTrade;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Items;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;

@Mod.EventBusSubscriber(modid="playertrade", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.DEDICATED_SERVER})
public class TradeEventHandler {
    public static HashMap<UUID, HashMap<UUID, Integer>> tradeTicker = new HashMap();
    public static int tradeTimer = 8;

    public static PlayerEntity getTradePartner(PlayerEntity player) {
        HashMap<UUID, Integer> sourceMap;
        PlayerEntity partner = null;
        if (player.field_71070_bA instanceof ContainerTrade && (sourceMap = tradeTicker.get(player.func_110124_au())) != null) {
            Iterator<Map.Entry<UUID, Integer>> targetIter = sourceMap.entrySet().iterator();
            Map.Entry<UUID, Integer> targetPair = null;
            while (targetIter.hasNext()) {
                targetPair = targetIter.next();
                PlayerEntity target = ((ServerPlayerEntity)player).func_130014_f_().func_217371_b(targetPair.getKey());
                int ticker = targetPair.getValue();
                if (ticker >= 0) continue;
                return target;
            }
        }
        return partner;
    }

    @SubscribeEvent
    public static void onPlayerItemPickup(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_71070_bA instanceof ContainerTrade) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractPlayer(PlayerInteractEvent.EntityInteract event) {
        if (!event.getWorld().field_72995_K && (event.getPlayer().func_184586_b(event.getHand()) == null || event.getPlayer().func_184586_b(event.getHand()).func_77973_b() == null || event.getPlayer().func_184586_b(event.getHand()).func_77973_b().equals(Items.field_190931_a))) {
            Entity t = event.getTarget();
            ServerPlayerEntity source = (ServerPlayerEntity)event.getPlayer();
            if (t instanceof ServerPlayerEntity) {
                HashMap<UUID, Integer> targetMap;
                ServerPlayerEntity target = (ServerPlayerEntity)event.getTarget();
                HashMap<UUID, Integer> sourceMap = tradeTicker.get(source.func_110124_au());
                if (sourceMap == null) {
                    sourceMap = new HashMap();
                }
                if ((targetMap = tradeTicker.get(target.func_110124_au())) != null && targetMap.containsKey(source.func_110124_au())) {
                    int targetCounter = targetMap.get(source.func_110124_au());
                    if (targetCounter <= tradeTimer) {
                        sourceMap.put(target.func_110124_au(), -2);
                        targetMap.put(source.func_110124_au(), -2);
                        tradeTicker.put(target.func_110124_au(), targetMap);
                        tradeTicker.put(source.func_110124_au(), sourceMap);
                        NetworkHooks.openGui((ServerPlayerEntity)source, (INamedContainerProvider)new SimpleNamedContainerProvider((a, playerInv, player) -> ContainerTrade.createContainerServerSide(a, playerInv), null));
                        NetworkHooks.openGui((ServerPlayerEntity)target, (INamedContainerProvider)new SimpleNamedContainerProvider((a, playerInv, player) -> ContainerTrade.createContainerServerSide(a, playerInv), null));
                        sourceMap.put(target.func_110124_au(), -1);
                        targetMap.put(source.func_110124_au(), -1);
                        tradeTicker.put(target.func_110124_au(), targetMap);
                        tradeTicker.put(source.func_110124_au(), sourceMap);
                    }
                } else {
                    if (sourceMap.get(target.func_110124_au()) == null) {
                        TradeEventHandler.addChatMessage((PlayerEntity)target, (ITextComponent)new TranslationTextComponent("Received a trade request from ").func_230529_a_(source.func_200200_C_()));
                    }
                    sourceMap.put(target.func_110124_au(), 0);
                    tradeTicker.put(source.func_110124_au(), sourceMap);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        ServerPlayerEntity player;
        HashMap<UUID, Integer> sourceMap;
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().field_70173_aa % 20 == 0 && (sourceMap = tradeTicker.get((player = (ServerPlayerEntity)event.getEntityLiving()).func_110124_au())) != null) {
            Iterator<Map.Entry<UUID, Integer>> targetIter = sourceMap.entrySet().iterator();
            while (targetIter.hasNext()) {
                Map.Entry<UUID, Integer> targetPair = targetIter.next();
                int ticker = targetPair.getValue();
                if (ticker >= tradeTimer) {
                    targetIter.remove();
                } else if (ticker >= 0) {
                    targetPair.setValue(++ticker);
                }
                if (TradeEventHandler.getTradePartner((PlayerEntity)player) == null || ticker <= 0) continue;
                targetPair.setValue(-1);
            }
        }
    }

    @SubscribeEvent
    public static void onContainerClosed(PlayerContainerEvent.Close event) {
        ServerPlayerEntity closer;
        HashMap<UUID, Integer> sourceMap;
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getContainer() instanceof ContainerTrade && (sourceMap = tradeTicker.get((closer = (ServerPlayerEntity)event.getPlayer()).func_110124_au())) != null) {
            Iterator<Map.Entry<UUID, Integer>> targetIter = sourceMap.entrySet().iterator();
            Map.Entry<UUID, Integer> targetPair = null;
            while (targetIter.hasNext()) {
                targetPair = targetIter.next();
                ServerPlayerEntity target = (ServerPlayerEntity)closer.func_130014_f_().func_217371_b(targetPair.getKey());
                int ticker = targetPair.getValue();
                if (ticker != -1) continue;
                if (closer != null) {
                    tradeTicker.remove(closer.func_110124_au());
                }
                if (target != null) {
                    tradeTicker.remove(target.func_110124_au());
                    target.func_71053_j();
                    target.field_71070_bA = target.field_71069_bz;
                    target.field_71069_bz.func_75142_b();
                }
                if (closer == null) continue;
                closer.field_71069_bz.func_75142_b();
            }
        }
    }

    public static void addChatMessage(PlayerEntity player, ITextComponent message) {
        player.func_145747_a(message, Util.field_240973_b_);
    }
}

