/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.config.ClientConfig;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityDrawersRenderer
extends TileEntityRenderer<TileEntityDrawers> {
    private boolean[] renderAsBlock = new boolean[4];
    private ItemStack[] renderStacks = new ItemStack[4];
    private ItemRenderer renderItem;
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};
    public static final ResourceLocation TEXTURE_IND_1 = new ResourceLocation("storagedrawers", "blocks/indicator/indicator_1_on");
    public static final ResourceLocation TEXTURE_IND_2 = new ResourceLocation("storagedrawers", "blocks/indicator/indicator_2_on");
    public static final ResourceLocation TEXTURE_IND_4 = new ResourceLocation("storagedrawers", "blocks/indicator/indicator_4_on");
    public static final ResourceLocation TEXTURE_IND_COMP = new ResourceLocation("storagedrawers", "blocks/indicator/indicator_comp_on");

    public TileEntityDrawersRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEntityDrawers tile, float partialTickTime, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (tile == null) {
            return;
        }
        World world = tile.func_145831_w();
        if (world == null) {
            return;
        }
        BlockState state = world.func_180495_p(tile.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockDrawers)) {
            return;
        }
        Direction side = (Direction)state.func_177229_b((Property)BlockDrawers.field_185512_D);
        if (this.playerBehindBlock(tile.func_174877_v(), side)) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        BlockPos blockPos = tile.func_174877_v().func_177963_a(0.5, 0.5, 0.5);
        float distance = (float)Math.sqrt(blockPos.func_177951_i((Vector3i)player.func_233580_cy_()));
        double renderDistance = (Double)ClientConfig.RENDER.labelRenderDistance.get();
        if (renderDistance > 0.0 && (double)distance > renderDistance) {
            return;
        }
        this.renderItem = Minecraft.func_71410_x().func_175599_af();
        if (tile.upgrades().hasIlluminationUpgrade()) {
            int blockLight = Math.max(combinedLight % 65536, 208);
            combinedLight = combinedLight & 0xFFFF0000 | blockLight;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GraphicsFanciness cache = mc.field_71474_y.field_238330_f_;
        mc.field_71474_y.field_238330_f_ = GraphicsFanciness.FANCY;
        if (!tile.getDrawerAttributes().isConcealed()) {
            this.renderFastItemSet(tile, state, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime, distance);
        }
        if (tile.getDrawerAttributes().hasFillLevel()) {
            this.renderIndicator((BlockDrawers)state.func_177230_c(), tile, matrix, buffer, (Direction)state.func_177229_b((Property)BlockDrawers.field_185512_D), combinedLight, combinedOverlay);
        }
        mc.field_71474_y.field_238330_f_ = cache;
        matrix.func_227865_b_();
        RenderHelper.func_227781_a_((Matrix4f)matrix.func_227866_c_().func_227870_a_());
        matrix.func_227860_a_();
    }

    private boolean playerBehindBlock(BlockPos blockPos, Direction facing) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        BlockPos playerPos = player.func_233580_cy_();
        switch (facing) {
            case NORTH: {
                return playerPos.func_177952_p() > blockPos.func_177952_p();
            }
            case SOUTH: {
                return playerPos.func_177952_p() < blockPos.func_177952_p();
            }
            case WEST: {
                return playerPos.func_177958_n() > blockPos.func_177958_n();
            }
            case EAST: {
                return playerPos.func_177958_n() < blockPos.func_177958_n();
            }
        }
        return false;
    }

    private void renderFastItemSet(TileEntityDrawers tile, BlockState state, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, Direction side, float partialTickTime, float distance) {
        int i;
        int drawerCount = tile.getGroup().getDrawerCount();
        for (i = 0; i < drawerCount; ++i) {
            ItemStack itemStack;
            this.renderStacks[i] = ItemStack.field_190927_a;
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (!drawer.isEnabled() || drawer.isEmpty()) continue;
            this.renderStacks[i] = itemStack = drawer.getStoredItemPrototype();
            this.renderAsBlock[i] = this.isItemBlockType(itemStack);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i].func_190926_b() || this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, state, i, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i].func_190926_b() || !this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, state, i, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime);
        }
        if (tile.getDrawerAttributes().isShowingQuantity()) {
            double renderDistance;
            float alpha = 1.0f;
            double fadeDistance = (Double)ClientConfig.RENDER.quantityFadeDistance.get();
            if (fadeDistance == 0.0 || (double)distance > fadeDistance) {
                alpha = Math.max(1.0f - (distance - 4.0f) / 6.0f, 0.05f);
            }
            if ((renderDistance = ((Double)ClientConfig.RENDER.quantityRenderDistance.get()).doubleValue()) == 0.0 || (double)distance < renderDistance) {
                IRenderTypeBuffer.Impl txtBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                for (int i2 = 0; i2 < drawerCount; ++i2) {
                    String format = CountFormatter.format(this.field_228858_b_.func_147548_a(), tile.getGroup().getDrawer(i2));
                    this.renderText(format, state, i2, matrix, (IRenderTypeBuffer)txtBuffer, combinedLight, side, alpha);
                }
                txtBuffer.func_228461_a_();
            }
        }
    }

    private void renderText(String text, BlockState state, int slot, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, Direction side, float alpha) {
        if (text == null || text.isEmpty()) {
            return;
        }
        FontRenderer fontRenderer = this.field_228858_b_.func_147548_a();
        BlockDrawers block = (BlockDrawers)state.func_177230_c();
        AxisAlignedBB labelGeometry = block.countGeometry[slot];
        int textWidth = fontRenderer.func_78256_a(text);
        float x = (float)(labelGeometry.field_72340_a + labelGeometry.func_216364_b() / 2.0);
        float y = 16.0f - (float)labelGeometry.field_72338_b - (float)labelGeometry.func_216360_c();
        float z = (float)labelGeometry.field_72339_c * 0.0625f - 0.01f;
        matrix.func_227860_a_();
        this.alignRendering(matrix, side);
        this.moveRendering(matrix, 0.125f, 0.125f, x, y, z);
        int color = (int)(255.0f * alpha) << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        fontRenderer.func_228079_a_(text, (float)(-textWidth) / 2.0f, 0.5f, color, false, matrix.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLight);
        matrix.func_227865_b_();
    }

    private void renderFastItem(@Nonnull ItemStack itemStack, TileEntityDrawers tile, BlockState state, int slot, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, Direction side, float partialTickTime) {
        BlockDrawers block = (BlockDrawers)state.func_177230_c();
        AxisAlignedBB labelGeometry = block.labelGeometry[slot];
        float scaleX = (float)labelGeometry.func_216364_b() / 16.0f;
        float scaleY = (float)labelGeometry.func_216360_c() / 16.0f;
        float moveX = (float)labelGeometry.field_72340_a + 8.0f * scaleX;
        float moveY = 16.0f - (float)labelGeometry.field_72337_e + 8.0f * scaleY;
        float moveZ = (float)labelGeometry.field_72339_c * 0.0625f;
        matrix.func_227860_a_();
        this.alignRendering(matrix, side);
        this.moveRendering(matrix, scaleX, scaleY, moveX, moveY, moveZ);
        Consumer<IRenderTypeBuffer> finish = buf -> {
            if (buf instanceof IRenderTypeBuffer.Impl) {
                ((IRenderTypeBuffer.Impl)buf).func_228461_a_();
            }
        };
        try {
            matrix.func_227861_a_(0.0, 0.0, 100.0);
            matrix.func_227862_a_(1.0f, -1.0f, 1.0f);
            matrix.func_227862_a_(16.0f, 16.0f, 16.0f);
            IBakedModel itemModel = this.renderItem.func_184393_a(itemStack, null, null);
            boolean render3D = itemModel.func_177556_c();
            finish.accept(buffer);
            if (render3D) {
                RenderHelper.func_227784_d_();
            } else {
                RenderHelper.func_227783_c_();
            }
            matrix.func_227866_c_().func_227872_b_().func_226114_a_(Matrix3f.func_226117_b_((float)1.0f, (float)-1.0f, (float)1.0f));
            this.renderItem.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.GUI, false, matrix, buffer, combinedLight, combinedOverlay, itemModel);
            finish.accept(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrix.func_227865_b_();
    }

    private boolean isItemBlockType(@Nonnull ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof BlockItem;
    }

    private void alignRendering(MatrixStack matrix, Direction side) {
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, this.getRotationYForSide2D(side), true));
        matrix.func_227861_a_(-0.5, -0.5, -0.5);
    }

    private void moveRendering(MatrixStack matrix, float scaleX, float scaleY, float offsetX, float offsetY, float offsetZ) {
        matrix.func_227861_a_(0.0, 1.0, (double)(1.0f - offsetZ));
        matrix.func_227862_a_(0.0625f, -0.0625f, 5.0E-5f);
        matrix.func_227861_a_((double)offsetX, (double)offsetY, 0.0);
        matrix.func_227862_a_(scaleX, scaleY, 1.0f);
    }

    private float getRotationYForSide2D(Direction side) {
        return sideRotationY2D[side.ordinal()] * 90.0f;
    }

    private void renderIndicator(BlockDrawers block, TileEntityDrawers tile, MatrixStack matrixStack, IRenderTypeBuffer buffer, Direction side, int combinedLight, int combinedOverlay) {
        int count = tile instanceof TileEntityDrawersComp ? 1 : block.getDrawerCount();
        ResourceLocation resource = TEXTURE_IND_1;
        if (tile instanceof TileEntityDrawersComp) {
            resource = TEXTURE_IND_COMP;
        } else if (count == 2) {
            resource = TEXTURE_IND_2;
        } else if (count == 4) {
            resource = TEXTURE_IND_4;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(resource);
        float u1 = sprite.func_94209_e();
        float u2 = sprite.func_94212_f();
        float v1 = sprite.func_94206_g();
        float v2 = sprite.func_94210_h();
        float pxW = sprite.func_94211_a();
        float pxH = sprite.func_94216_b();
        float unit = 0.0625f;
        float divU = unit * (u2 - u1);
        float divV = unit * (v2 - v1);
        matrixStack.func_227860_a_();
        this.alignRendering(matrixStack, side);
        for (int i = 0; i < count; ++i) {
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (drawer == Drawers.DISABLED || tile.getDrawerAttributes().isConcealed()) continue;
            AxisAlignedBB bb = block.indGeometry[i];
            AxisAlignedBB bbbase = block.indBaseGeometry[i];
            float x1 = unit * (float)bb.field_72340_a;
            float x2 = unit * (float)bb.field_72336_d;
            float xb2 = unit * (float)bbbase.field_72336_d;
            float y1 = unit * (float)bb.field_72338_b;
            float y2 = unit * (float)bb.field_72337_e;
            float yb2 = unit * (float)bbbase.field_72337_e;
            float z = 1.0f - unit * (float)bb.field_72339_c;
            float su1 = u1 + (float)bb.field_72340_a * divU;
            float su2 = u1 + (float)bb.field_72336_d * divU;
            float sv1 = v2 - (float)bb.field_72338_b * divV;
            float sv2 = v2 - (float)bb.field_72337_e * divV;
            int stepX = (int)((x2 - xb2) * pxW);
            int stepY = (int)((y2 - yb2) * pxH);
            float xCur = stepX == 0 ? x2 : this.getIndEnd(tile, i, x1, x2 - xb2, stepX);
            float xFrac = x2 == xb2 ? 1.0f : (xCur - x1) / (x2 - xb2);
            float uCur = su1 + xFrac * (su2 - su1);
            float yCur = stepY == 0 ? y2 : this.getIndEnd(tile, i, y1, y2 - yb2, stepY);
            float yFrac = y2 == yb2 ? 1.0f : (yCur - y1) / (y2 - yb2);
            float vCur = sv1 + yFrac * (sv2 - sv1);
            if (!(xCur > x1) || !(yCur > y1)) continue;
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            Matrix3f normal = matrixStack.func_227866_c_().func_227872_b_();
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
            TileEntityDrawersRenderer.addQuad(matrix, normal, builder, combinedLight, combinedOverlay, x1, xCur, y1, yCur, z, uCur, su1, sv1, vCur);
        }
        matrixStack.func_227865_b_();
    }

    public static void addQuad(Matrix4f matrix, Matrix3f normal, IVertexBuilder buffer, int combinedLight, int combinedOverlay, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2) {
        TileEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x2, y1, z, u1, v1);
        TileEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x2, y2, z, u1, v2);
        TileEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x1, y2, z, u2, v2);
        TileEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x1, y1, z, u2, v1);
    }

    private static void addVertex(Matrix4f matrix, Matrix3f normal, IVertexBuilder buffer, int combinedLight, int combinedOverlay, float x, float y, float z, float u, float v) {
        buffer.func_227888_a_(matrix, x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u, v).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private float getIndEnd(TileEntityDrawers tile, int slot, float x, float w, int step) {
        IDrawer drawer = tile.getGroup().getDrawer(slot);
        if (drawer == Drawers.DISABLED) {
            return x;
        }
        int cap = drawer.getMaxCapacity();
        int count = drawer.getStoredItemCount();
        if (cap == 0 || count == 0) {
            return x;
        }
        float fillAmt = (float)(step * count / cap) / (float)step;
        return x + w * fillAmt;
    }
}

