/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class KeyCodeEntry
extends TooltipListEntry<ModifierKeyCode> {
    private ModifierKeyCode value;
    private final ModifierKeyCode original;
    private final Button buttonWidget;
    private final Button resetButton;
    private final Consumer<ModifierKeyCode> saveConsumer;
    private final Supplier<ModifierKeyCode> defaultValue;
    private final List<IGuiEventListener> widgets;
    private boolean allowMouse = true;
    private boolean allowKey = true;
    private boolean allowModifiers = true;

    @Deprecated
    @ApiStatus.Internal
    public KeyCodeEntry(ITextComponent fieldName, ModifierKeyCode value, ITextComponent resetButtonKey, Supplier<ModifierKeyCode> defaultValue, Consumer<ModifierKeyCode> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.value = value.copy();
        this.original = value.copy();
        this.buttonWidget = new Button(0, 0, 150, 20, NarratorChatListener.field_216868_a, widget -> this.getConfigScreen().setFocusedBinding(this));
        this.resetButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)resetButtonKey) + 6, 20, resetButtonKey, widget -> {
            this.value = ((ModifierKeyCode)this.getDefaultValue().orElse(null)).copy();
            this.getConfigScreen().setFocusedBinding(null);
        });
        this.saveConsumer = saveConsumer;
        this.widgets = Lists.newArrayList((Object[])new IGuiEventListener[]{this.buttonWidget, this.resetButton});
    }

    @Override
    public boolean isEdited() {
        return super.isEdited() || !this.original.equals(this.getValue());
    }

    public boolean isAllowModifiers() {
        return this.allowModifiers;
    }

    public void setAllowModifiers(boolean allowModifiers) {
        this.allowModifiers = allowModifiers;
    }

    public boolean isAllowKey() {
        return this.allowKey;
    }

    public void setAllowKey(boolean allowKey) {
        this.allowKey = allowKey;
    }

    public boolean isAllowMouse() {
        return this.allowMouse;
    }

    public void setAllowMouse(boolean allowMouse) {
        this.allowMouse = allowMouse;
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    public ModifierKeyCode getValue() {
        return this.value;
    }

    public void setValue(ModifierKeyCode value) {
        this.value = value;
    }

    @Override
    public Optional<ModifierKeyCode> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue).map(Supplier::get).map(ModifierKeyCode::copy);
    }

    private ITextComponent getLocalizedName() {
        return this.value.getLocalizedName();
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.resetButton.field_230693_o_ = this.isEditable() && this.getDefaultValue().isPresent() && !this.getDefaultValue().get().equals(this.getValue());
        this.resetButton.field_230691_m_ = y;
        this.buttonWidget.field_230693_o_ = this.isEditable();
        this.buttonWidget.field_230691_m_ = y;
        this.buttonWidget.func_238482_a_(this.getLocalizedName());
        if (this.getConfigScreen().getFocusedBinding() == this) {
            this.buttonWidget.func_238482_a_((ITextComponent)new StringTextComponent("> ").func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)this.buttonWidget.func_230458_i_().func_230531_f_().func_240699_a_(TextFormatting.YELLOW)).func_230529_a_((ITextComponent)new StringTextComponent(" <").func_240699_a_(TextFormatting.WHITE)));
        }
        ITextComponent displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, displayedFieldName.func_241878_f(), (float)(window.func_198107_o() - x - Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)displayedFieldName)), (float)(y + 6), 0xFFFFFF);
            this.resetButton.field_230690_l_ = x;
            this.buttonWidget.field_230690_l_ = x + this.resetButton.func_230998_h_() + 2;
        } else {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, displayedFieldName.func_241878_f(), (float)x, (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.field_230690_l_ = x + entryWidth - this.resetButton.func_230998_h_();
            this.buttonWidget.field_230690_l_ = x + entryWidth - 150;
        }
        this.buttonWidget.func_230991_b_(150 - this.resetButton.func_230998_h_() - 2);
        this.resetButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.buttonWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.widgets;
    }
}

