/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.gui.entries;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.Tooltip;
import me.shedaniel.math.Point;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class TooltipListEntry<T>
extends AbstractConfigListEntry<T> {
    private @Nullable Supplier<Optional<ITextComponent[]>> tooltipSupplier;

    @Deprecated
    public TooltipListEntry(ITextComponent fieldName, @Nullable Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this(fieldName, tooltipSupplier, false);
    }

    @Deprecated
    public TooltipListEntry(ITextComponent fieldName, @Nullable Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, requiresRestart);
        this.tooltipSupplier = tooltipSupplier;
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        Optional<ITextComponent[]> tooltip;
        if (this.isMouseInside(mouseX, mouseY, x, y, entryWidth, entryHeight) && (tooltip = this.getTooltip()).isPresent() && tooltip.get().length > 0) {
            this.addTooltip(Tooltip.of(new Point(mouseX, mouseY), tooltip.get()));
        }
    }

    public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
        return mouseX >= x && mouseY >= y && mouseX <= x + entryWidth && mouseY <= y + entryHeight && this.getParent().func_231047_b_(mouseX, mouseY);
    }

    public Optional<ITextComponent[]> getTooltip() {
        if (this.tooltipSupplier != null) {
            return this.tooltipSupplier.get();
        }
        return Optional.empty();
    }

    public @Nullable Supplier<Optional<ITextComponent[]>> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public void setTooltipSupplier(@Nullable Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
    }
}

