/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.loading.FMLPaths;
import top.theillusivec4.polymorph.common.PolymorphMod;
import top.theillusivec4.polymorph.mixin.core.AccessorSmithingRecipe;

public class PolymorphCommands {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"polymorph").requires(player -> player.func_197034_c(2));
        command.then(Commands.func_197057_a((String)"conflicts").executes(context -> PolymorphCommands.findConflicts((CommandSource)context.getSource())));
        dispatcher.register(command);
    }

    private static int findConflicts(CommandSource source) {
        CompletableFuture.runAsync(() -> {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.polymorph.conflicts.starting"), true);
            ServerWorld world = source.func_197023_e();
            RecipeManager recipeManager = world.func_199532_z();
            ArrayList<String> output = new ArrayList<String>();
            int count = 0;
            count += PolymorphCommands.scanRecipes(IRecipeType.field_222149_a, output, recipeManager, x$0 -> new CraftingRecipeWrapper((IRecipe)x$0));
            count += PolymorphCommands.scanRecipes(IRecipeType.field_222150_b, output, recipeManager, x$0 -> new RecipeWrapper((IRecipe)x$0));
            count += PolymorphCommands.scanRecipes(IRecipeType.field_222151_c, output, recipeManager, x$0 -> new RecipeWrapper((IRecipe)x$0));
            count += PolymorphCommands.scanRecipes(IRecipeType.field_222152_d, output, recipeManager, x$0 -> new RecipeWrapper((IRecipe)x$0));
            if ((count += PolymorphCommands.scanRecipes(IRecipeType.field_234827_g_, output, recipeManager, x$0 -> new SmithingRecipeWrapper((IRecipe)x$0))) > 0) {
                try {
                    Files.write(Paths.get(FMLPaths.GAMEDIR.get() + "/logs/conflicts.log", new String[0]), output, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    PolymorphMod.LOGGER.error("Whoops! Something went wrong writing down your conflicts :(");
                    e.printStackTrace();
                }
            }
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.polymorph.conflicts.success", new Object[]{count}), true);
        });
        return 1;
    }

    private static <C extends IInventory, T extends IRecipe<C>> int scanRecipes(IRecipeType<T> pType, List<String> pOutput, RecipeManager pRecipeManager, Function<IRecipe<?>, RecipeWrapper> pFactory) {
        Collection recipes = pRecipeManager.func_241447_a_(pType).stream().map(pFactory).collect(Collectors.toList());
        ArrayList conflicts = new ArrayList();
        TreeSet<ResourceLocation> skipped = new TreeSet<ResourceLocation>();
        HashSet<ResourceLocation> processed = new HashSet<ResourceLocation>();
        for (RecipeWrapper recipe : recipes) {
            ResourceLocation resourceLocation = recipe.getId();
            if (processed.contains(resourceLocation)) continue;
            processed.add(resourceLocation);
            if (recipe.getRecipe() instanceof SpecialRecipe) {
                skipped.add(resourceLocation);
                continue;
            }
            TreeSet<ResourceLocation> currentGroup = new TreeSet<ResourceLocation>();
            for (RecipeWrapper otherRecipe : recipes) {
                if (processed.contains(otherRecipe.getId()) || !otherRecipe.conflicts(recipe)) continue;
                currentGroup.add(resourceLocation);
                currentGroup.add(otherRecipe.getId());
                processed.add(otherRecipe.getId());
            }
            if (currentGroup.isEmpty()) continue;
            conflicts.add(currentGroup);
        }
        pOutput.add("===================================================================");
        pOutput.add(Registry.field_218367_H.func_177774_c(pType) + " recipe conflicts (" + conflicts.size() + ")");
        pOutput.add("===================================================================");
        pOutput.add("");
        int count = 1;
        for (Set set : conflicts) {
            StringJoiner joiner = new StringJoiner(", ");
            set.stream().map(ResourceLocation::toString).forEach(joiner::add);
            pOutput.add(count + ": " + joiner);
            pOutput.add("");
            ++count;
        }
        if (skipped.size() > 0) {
            pOutput.add("Skipped special recipes: ");
            for (ResourceLocation resourceLocation : skipped) {
                pOutput.add(resourceLocation.toString());
            }
            pOutput.add("");
        }
        return conflicts.size();
    }

    private static class CraftingRecipeWrapper
    extends RecipeWrapper {
        private final boolean shaped;

        private CraftingRecipeWrapper(IRecipe<?> pRecipe) {
            super(pRecipe);
            this.shaped = pRecipe instanceof IShapedRecipe;
        }

        public boolean isShaped() {
            return this.shaped;
        }

        @Override
        public boolean conflicts(RecipeWrapper pOther) {
            return super.conflicts(pOther) && this.isSameShape((CraftingRecipeWrapper)pOther);
        }

        private boolean isSameShape(CraftingRecipeWrapper pOther) {
            if (this.shaped && pOther.isShaped()) {
                IShapedRecipe shaped = (IShapedRecipe)this.getRecipe();
                IShapedRecipe otherShaped = (IShapedRecipe)pOther.getRecipe();
                return shaped.getRecipeHeight() == otherShaped.getRecipeHeight() && shaped.getRecipeWidth() == otherShaped.getRecipeWidth();
            }
            return true;
        }
    }

    private static class SmithingRecipeWrapper
    extends RecipeWrapper {
        private SmithingRecipeWrapper(IRecipe<?> pRecipe) {
            super(pRecipe);
        }

        @Override
        public boolean conflicts(RecipeWrapper pOther) {
            AccessorSmithingRecipe smithingRecipe = (AccessorSmithingRecipe)this.getRecipe();
            AccessorSmithingRecipe otherSmithingRecipe = (AccessorSmithingRecipe)pOther.getRecipe();
            IngredientWrapper baseWrapper = new IngredientWrapper(smithingRecipe.getBase());
            IngredientWrapper otherBaseWrapper = new IngredientWrapper(otherSmithingRecipe.getBase());
            IngredientWrapper additionWrapper = new IngredientWrapper(smithingRecipe.getAddition());
            IngredientWrapper otherAdditionWrapper = new IngredientWrapper(otherSmithingRecipe.getAddition());
            return super.conflicts(pOther) && baseWrapper.matches(otherBaseWrapper) & additionWrapper.matches(otherAdditionWrapper);
        }
    }

    private static class RecipeWrapper {
        private final IRecipe<?> recipe;
        private final List<IngredientWrapper> ingredients;

        private RecipeWrapper(IRecipe<?> pRecipe) {
            this.recipe = pRecipe;
            this.ingredients = new ArrayList<IngredientWrapper>();
            for (Ingredient ingredient : this.recipe.func_192400_c()) {
                IngredientWrapper wrapped = new IngredientWrapper(ingredient);
                this.ingredients.add(wrapped);
            }
        }

        public IRecipe<?> getRecipe() {
            return this.recipe;
        }

        public ResourceLocation getId() {
            return this.recipe.func_199560_c();
        }

        public List<IngredientWrapper> getIngredients() {
            return this.ingredients;
        }

        public boolean conflicts(RecipeWrapper pOther) {
            if (pOther == null) {
                return false;
            }
            if (this.getId().equals((Object)pOther.getId())) {
                return true;
            }
            if (this.ingredients.size() != pOther.getIngredients().size()) {
                return false;
            }
            List<IngredientWrapper> otherIngredients = pOther.getIngredients();
            for (int i = 0; i < otherIngredients.size(); ++i) {
                if (otherIngredients.get(i).matches(this.getIngredients().get(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class IngredientWrapper {
        private final Ingredient ingredient;

        private IngredientWrapper(Ingredient pIngredient) {
            this.ingredient = pIngredient;
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public boolean matches(IngredientWrapper pIngredient) {
            if (pIngredient == null) {
                return false;
            }
            Ingredient otherIngredient = pIngredient.getIngredient();
            if (otherIngredient == null) {
                return false;
            }
            if (otherIngredient == Ingredient.field_193370_a) {
                return this.ingredient == Ingredient.field_193370_a;
            }
            ItemStack[] stacks = this.ingredient.func_193365_a();
            for (ItemStack otherStack : pIngredient.getIngredient().func_193365_a()) {
                for (ItemStack stack : stacks) {
                    if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)otherStack)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

