/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.server;

import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;
import top.theillusivec4.polymorph.common.impl.RecipePair;
import top.theillusivec4.polymorph.common.network.server.ClientPacketHandler;

public class SPacketRecipesList {
    private final SortedSet<IRecipePair> recipeList = new TreeSet<IRecipePair>();
    private final ResourceLocation selected;

    public SPacketRecipesList(SortedSet<IRecipePair> pRecipeList, ResourceLocation pSelected) {
        if (pRecipeList != null) {
            this.recipeList.addAll(pRecipeList);
        }
        this.selected = pSelected;
    }

    public SortedSet<IRecipePair> getRecipeList() {
        return this.recipeList;
    }

    public ResourceLocation getSelected() {
        return this.selected;
    }

    public static void encode(SPacketRecipesList pPacket, PacketBuffer pBuffer) {
        if (!pPacket.recipeList.isEmpty()) {
            pBuffer.writeInt(pPacket.recipeList.size());
            for (IRecipePair data : pPacket.recipeList) {
                pBuffer.func_192572_a(data.getResourceLocation());
                pBuffer.func_150788_a(data.getOutput());
            }
            if (pPacket.selected != null) {
                pBuffer.func_192572_a(pPacket.selected);
            }
        }
    }

    public static SPacketRecipesList decode(PacketBuffer pBuffer) {
        TreeSet<IRecipePair> recipeDataset = new TreeSet<IRecipePair>();
        ResourceLocation selected = null;
        if (pBuffer.isReadable()) {
            int size = pBuffer.readInt();
            for (int i = 0; i < size; ++i) {
                recipeDataset.add(new RecipePair(pBuffer.func_192575_l(), pBuffer.func_150791_c()));
            }
            if (pBuffer.isReadable()) {
                selected = pBuffer.func_192575_l();
            }
        }
        return new SPacketRecipesList(recipeDataset, selected);
    }

    public static void handle(SPacketRecipesList pPacket, Supplier<NetworkEvent.Context> pContext) {
        pContext.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handle(pPacket)));
        pContext.get().setPacketHandled(true);
    }
}

