/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.client;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.PolymorphIntegrations;

public class CPacketStackRecipeSelection {
    private final ResourceLocation recipe;

    public CPacketStackRecipeSelection(ResourceLocation pResourceLocation) {
        this.recipe = pResourceLocation;
    }

    public static void encode(CPacketStackRecipeSelection pPacket, PacketBuffer pBuffer) {
        pBuffer.func_192572_a(pPacket.recipe);
    }

    public static CPacketStackRecipeSelection decode(PacketBuffer pBuffer) {
        return new CPacketStackRecipeSelection(pBuffer.func_192575_l());
    }

    public static void handle(CPacketStackRecipeSelection pPacket, Supplier<NetworkEvent.Context> pContext) {
        pContext.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)pContext.get()).getSender();
            if (sender != null) {
                World world = sender.func_130014_f_();
                Optional maybeRecipe = world.func_199532_z().func_215367_a(pPacket.recipe);
                maybeRecipe.ifPresent(recipe -> {
                    Container container = sender.field_71070_bA;
                    PolymorphApi.common().getRecipeDataFromItemStack(container).ifPresent(recipeData -> {
                        recipeData.selectRecipe((IRecipe<?>)recipe);
                        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
                            if (!integration.selectRecipe(container, (IRecipe<?>)recipe)) continue;
                            return;
                        }
                    });
                });
            }
        });
        pContext.get().setPacketHandled(true);
    }
}

